/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the RetroPlatform Library
 *
 * The RetroPlatform Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 * This library is inspired by Gamebuino Library (http://gamebuino.com)
 * from Aurélien Rodot. 
 */
#ifndef DISPLAY_H
#define DISPLAY_H

#include "LCD_ST7735.h"


class Display : public LCD_ST7735
{

public:
    Display(
        PinName backlightPin,
        PinName resetPin,
        PinName dsPin,
        PinName mosiPin,
        PinName misoPin,
        PinName clkPin,
        PinName csPin,
        PanelColorFilter colorFilter = BGR
    );

    void drawBitmapIndexed(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp);
    void drawBitmapIndexed(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp, const uint16_t *palette, bool mirrored = false);
    //void drawBitmapTransparent(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp, const uint16_t *palette, uint8_t color, bool mirrored = false);
    void drawBitmapIndexed(uint8_t x, uint8_t y, int w, int h, int src_x, int src_y, int srcWidth, int srcHeight, const uint8_t *pbmp, const uint16_t *palette);
    
    void drawBitmapIndexed(uint8_t x, uint8_t y, const uint8_t *pbmp);
    void eraseBitmapIndexed(uint8_t x, uint8_t y, uint8_t w, uint8_t h,  const uint8_t *pbmp);
    void eraseBitmapIndexed(uint8_t x, uint8_t y, const uint8_t *pbmp);
};


#endif //DISPLAY_H