#include "mbed.h"
#include "DisplayN18.h"
#include "Timer.h"

//Display is 128x160
#define SQUARE_SIZE 3
#define COLUMNS 40
#define ROWS 32

DigitalIn left(P0_14, PullUp);
DigitalIn right(P0_11, PullUp);
DigitalIn down(P0_12, PullUp);
DigitalIn up(P0_13, PullUp);
DigitalIn square(P0_16, PullUp);
DigitalIn circle(P0_1, PullUp);
         
DisplayN18 disp;

char width = 160;
char height = 128;

short snake_body[256];
short snake_length = 3;

char LEFT = 0;
char RIGHT = 1;
char UP = 2;
char DOWN = 3;

char snake_direction = LEFT; 

char bonus_x, bonus_y;

unsigned long loopStartTime = 0;
 
void checkButtons()
{
    int buttonState = left.read();
    
    if( buttonState == 0 )
    {
        snake_direction = LEFT;
        
        return;
    }
    
    buttonState = right.read();
    

    if( buttonState == 0 )
    {
        snake_direction = RIGHT;
        
        return;
    }    
    
    buttonState = up.read();
    

    if( buttonState == 0 )
    {
        snake_direction = UP;
        
        return;
    }
    
    buttonState = down.read();
    

    if( buttonState == 0 )
    {
        snake_direction = DOWN;

        
        return;
    }
    
    buttonState = square.read();
    
    if( buttonState == 0 )
    {

    }
    
}

bool move_snake()
{
    //"Erase" tale here
    disp.fillRect( (snake_body[snake_length - 1] >> 8) * (SQUARE_SIZE + 1) , (snake_body[snake_length - 1] & 0x00FF)* (SQUARE_SIZE + 1) , SQUARE_SIZE, SQUARE_SIZE, DisplayN18::rgbToShort(0, 0, 0)); 

    for (int i = snake_length - 1; i > 0; i--)
       snake_body[i] = snake_body[i-1];

    int headX = snake_body[0]>>8;
    int headY = snake_body[0]&0x00FF;

    switch (snake_direction)
    {
    case 0:
       headX -= 1;
       break;
    case 1:
       headX += 1;
       break;
    case 2:
       headY -= 1;
       break;
    case 3:
       headY += 1;
       break;
    }

    if (headX < 0)
       headX = COLUMNS-1;

    if (headX >= COLUMNS )
       headX = 0;

    if (headY < 0)
       headY = ROWS-1;

    if (headY >= ROWS)
       headY = 0;

    snake_body[0] = headX<<8|headY; 

    for (int i = 1; i < snake_length - 1; i++)
    {
       if (headX == (snake_body[i]>>8) && headY == (snake_body[i] & 0x00FF))
          return true;
    }

    return false;  
}

void new_bonus()
{
    bonus_x = rand()%COLUMNS;
    bonus_y = rand()%ROWS;
}

void draw_snake()
{
    char x, y;
    for( int i = 0; i< snake_length; i++ )
    {
       x= (snake_body[i] >> 8) * (SQUARE_SIZE + 1);
       y= (snake_body[i] & 0x00FF)* (SQUARE_SIZE + 1);
       disp.fillRect( x , y , SQUARE_SIZE, SQUARE_SIZE, DisplayN18::Yellow); 
    }
}

void draw_bonus()
{
    disp.fillRect( bonus_x*(SQUARE_SIZE+1) , bonus_y*(SQUARE_SIZE+1) , SQUARE_SIZE, SQUARE_SIZE, DisplayN18::rgbToShort(0, 0, 255));   
}

void render()
{
    draw_snake();
    draw_bonus();
}

void reset_game()
{
    char startX = 15;
    char startY = 20;

    snake_body[0] = startX << 8 | startY;
    snake_body[1] = (startX) << 8 | (startY+1);
    snake_body[2] = (startX) << 8 | (startY+2);
    snake_length = 3;

    new_bonus();

    loopStartTime = 0;

    snake_direction = LEFT;

    render();
}



void clear_field()
{
    char x, y;
    for( int i = 0; i< snake_length; i++ )
    {
       x= (snake_body[i] >> 8) * (SQUARE_SIZE + 1);
       y= (snake_body[i] & 0x00FF)* (SQUARE_SIZE + 1);
       disp.fillRect( x , y , SQUARE_SIZE, SQUARE_SIZE, DisplayN18::rgbToShort(0, 0, 0)); 
    }

    disp.fillRect( bonus_x*(SQUARE_SIZE+1) , bonus_y*(SQUARE_SIZE+1) , SQUARE_SIZE, SQUARE_SIZE, DisplayN18::rgbToShort(0, 0, 0));     
}


main()
{


    AnalogIn ain(P0_15); 
    
    disp.clear();
    
    DigitalOut led1(LED1, false);
    
    srand(ain.read_u16());
        

    Timer timer;

    timer.start();
    
    int loopStartTime = timer.read_ms();
    while (true) 
    {   
        checkButtons();
        if( timer.read_ms() - loopStartTime > 200 )
        {
            if( move_snake() )
            {
                clear_field();
                reset_game();
                //return;
            }
            
            int headX = snake_body[0]>>8;
       int headY = snake_body[0]&0x00FF;

       if (headX == bonus_x && headY == bonus_y)
       {
          snake_body[snake_length++] = snake_body[snake_length-1];
          snake_body[snake_length++] = snake_body[snake_length-1];

          new_bonus();
       }
        render();
        
            loopStartTime = timer.read_ms();
        }
    }    
}


