#include "mbed.h"

#pragma once

class DisplayN18 {
    static const unsigned char STEP = 4;
    
    DigitalOut resetPin;
    DigitalOut backlightPin;
    DigitalOut rsPin;
    DigitalOut csPin;
    SPI spi;

    void writeCommand(unsigned char command);
    void writeData(unsigned char data);
    void writeData(const unsigned char* data, unsigned int length);

    void reset();
    void initialize();
    void setClippingArea(unsigned char x, unsigned char y, unsigned char width, unsigned char height);

    public:
        DisplayN18();
        
    /**White*/
    static const uint16_t White;
    
    /**Silver*/
    static const uint16_t Silver;
    
    /**Gray*/
    static const uint16_t Gray;
    
    /**Black*/
    static const uint16_t Black;
    
    /**Red*/
    static const uint16_t Red;
    
    /**Maroon*/
    static const uint16_t Maroon;
    
    /**Yellow*/
    static const uint16_t Yellow;
    
    /**Olive*/
    static const uint16_t Olive;
    
    /**Lime*/
    static const uint16_t Lime;
    
    /**Green*/
    static const uint16_t Green;
    
    /**Aqua*/
    static const uint16_t Aqua;
    
    /**Teal*/
    static const uint16_t Teal;
    
    /**Blue*/
    static const uint16_t Blue;
    
    /**Navy*/
    static const uint16_t Navy;
    
    /**Fuchsia*/
    static const uint16_t Fuchsia;
    
    /**Purple*/
    static const uint16_t Purple;

        static const unsigned int WIDTH = 160;
        static const unsigned int HEIGHT = 128;
        static const unsigned char CHAR_WIDTH = 5;
        static const unsigned char CHAR_HEIGHT = 8;
        static const unsigned char CHAR_SPACING = 1;

        static unsigned short rgbToShort(unsigned char r, unsigned char g, unsigned char b);

        void clear(unsigned short backColor = 0x0000);
        void draw(const unsigned short* data, int x, int y, int width, int height);
        void setPixel(int x, int y, unsigned short foreColor);

        void fillRect(int x, int y, int width, int height, unsigned short foreColor);
        void drawRect(int x, int y, int width, int height, unsigned short foreColor);

        void fillCircle(int x, int y, int radius, unsigned short foreColor);
        void drawCircle(int x, int y, int radius, unsigned short foreColor);

        void drawLine(int x0, int y0, int x1, int y1, unsigned short foreColor);

        void drawCharacter(int x, int y, const char character, unsigned short foreColor, unsigned short backColor, unsigned char fontSize = 1);
        void drawString(int x, int y, const char* str, unsigned short foreColor, unsigned short backColor, unsigned char fontSize = 1);
};