/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the "Lost treasure of mBedungu" game application for Retro
 *
 * The "Lost treasure of mBedungu" application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */
 
#ifndef __SPRITES_H__
#define __SPRITES_H__

const uint8_t rick_top[] = {
0x00, 0x00, 0x45, 0x55, 0x55, 0x54, 0x00, 0x00, 
0x00, 0x45, 0x97, 0x77, 0x77, 0x76, 0xC4, 0x00, 
0x04, 0x67, 0x96, 0x96, 0x69, 0x99, 0x76, 0x40, 
0x0C, 0x79, 0x97, 0x89, 0x98, 0x79, 0x97, 0x50, 
0x49, 0x79, 0x77, 0x88, 0x78, 0x77, 0x97, 0x94, 
0x59, 0x77, 0xD7, 0x78, 0x88, 0x7D, 0x77, 0x95, 
0x59, 0x77, 0x7D, 0x77, 0x77, 0xD7, 0x77, 0x95, 
0x46, 0x77, 0x77, 0xDD, 0xDD, 0x77, 0x77, 0x64, 
0x4C, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x50, 
0x59, 0x76, 0x67, 0x77, 0x77, 0x76, 0x99, 0xC0, 
0x49, 0x7D, 0x76, 0x66, 0x66, 0x67, 0x9C, 0x40, 
0x05, 0x99, 0xC7, 0x77, 0x77, 0x76, 0xC4, 0x00, 
0x00, 0x46, 0x97, 0x7D, 0x7D, 0x77, 0xC0, 0x00, 
0x00, 0x4C, 0x97, 0x9C, 0x4C, 0xD6, 0xC4, 0x00, 
0x00, 0x45, 0x1C, 0x44, 0x5F, 0x15, 0x40, 0x00, 
0x00, 0x05, 0x55, 0x54, 0x55, 0x55, 0x50, 0x00
};

const uint8_t rick[] = {
0x00, 0x56, 0x78, 0x87, 0x66, 0x77, 0x50, 0x00, 
0x00, 0x57, 0x77, 0x88, 0x77, 0x78, 0x65, 0x00, 
0x55, 0x6D, 0xDD, 0xDD, 0xD8, 0xBD, 0x65, 0x55, 
0x55, 0x66, 0x66, 0x96, 0x96, 0x66, 0x66, 0x45, 
0x05, 0xDB, 0x7B, 0xBB, 0xB7, 0xBB, 0xBD, 0x50, 
0x05, 0xBB, 0xBB, 0x12, 0xBD, 0x77, 0x75, 0x00, 
0x05, 0x66, 0x6B, 0x1A, 0x32, 0x32, 0x50, 0x00, 
0x56, 0x68, 0x76, 0xB1, 0xA1, 0xBB, 0x75, 0x00, 
0x56, 0x68, 0x76, 0xDB, 0xBB, 0xBD, 0x65, 0x00, 
0x56, 0x67, 0x76, 0x55, 0x51, 0xA5, 0x50, 0x00, 
0x46, 0x66, 0x76, 0x67, 0x76, 0x76, 0x50, 0x00, 
0x5D, 0xBB, 0xBB, 0x66, 0x76, 0x65, 0x00, 0x00, 
0x05, 0x8B, 0xBD, 0x55, 0x55, 0x50, 0x00, 0x00, 
0x00, 0x05, 0x11, 0x3A, 0x14, 0x00, 0x00, 0x00, 
0x00, 0x05, 0x11, 0xA3, 0x11, 0x50, 0x00, 0x00, 
0x00, 0x04, 0x55, 0x55, 0x55, 0x54, 0x00, 0x00
}; 

const uint8_t barrel[] = {
0x00, 0x00, 0x45, 0x55, 0x55, 0x54, 0x00, 0x00, 
0x00, 0x45, 0x9D, 0xD7, 0xD7, 0x76, 0x54, 0x00, 
0x04, 0xCD, 0xD5, 0x45, 0x44, 0xC7, 0x9C, 0x40, 
0x05, 0x71, 0x4C, 0xCC, 0xCC, 0x54, 0xC7, 0x50, 
0x49, 0xD4, 0xCC, 0xC9, 0x9C, 0x99, 0x4D, 0x64, 
0x5D, 0x56, 0x66, 0x69, 0x96, 0x99, 0x6C, 0xD5, 
0x5D, 0x45, 0x44, 0x54, 0x54, 0x54, 0x44, 0xD5, 
0x5D, 0x49, 0x79, 0x77, 0x77, 0x97, 0x94, 0xD5, 
0x5D, 0x56, 0x66, 0xC6, 0x6C, 0x66, 0x64, 0xD5, 
0x57, 0x45, 0x45, 0xC4, 0x5C, 0x55, 0x54, 0xD5, 
0x5D, 0xC6, 0x67, 0x76, 0x77, 0x79, 0x65, 0xD5, 
0x46, 0x74, 0xCC, 0xCC, 0xCC, 0xCC, 0x4D, 0x64, 
0x05, 0x91, 0x4C, 0xCC, 0xCC, 0xC4, 0x1D, 0x50, 
0x04, 0xC7, 0xD5, 0x54, 0x54, 0xCD, 0x75, 0x40, 
0x00, 0x45, 0x67, 0x77, 0x77, 0x7C, 0x50, 0x00, 
0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00
}; 

const uint8_t crate[] = {
0x97, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 
0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89, 
0xCC, 0x96, 0xC6, 0x6C, 0xC9, 0xC6, 0xC6, 0x60, 
0x78, 0x97, 0x77, 0x98, 0x8C, 0x87, 0x77, 0x89, 
0x78, 0x97, 0x77, 0xC8, 0x7C, 0x77, 0x77, 0x89, 
0x78, 0xC8, 0x88, 0x98, 0x86, 0x88, 0x89, 0x89, 
0x98, 0x94, 0xC6, 0x48, 0x74, 0xCC, 0xC7, 0x89, 
0x78, 0xC8, 0x88, 0x98, 0x77, 0x88, 0x89, 0x89, 
0x78, 0xC8, 0x78, 0x98, 0x89, 0x78, 0x77, 0x86, 
0x78, 0x99, 0x99, 0x48, 0x7C, 0x79, 0x77, 0x89, 
0x98, 0xC8, 0x88, 0x98, 0x79, 0x88, 0x89, 0x89, 
0x78, 0x9C, 0xC6, 0x48, 0x84, 0x6C, 0xC7, 0x89, 
0x77, 0x48, 0x88, 0x98, 0x79, 0x88, 0x89, 0x8C, 
0x97, 0x77, 0x77, 0x79, 0x77, 0x77, 0x77, 0x7C, 
0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x89, 
0xC9, 0xCC, 0xCC, 0xC6, 0xCC, 0xCC, 0xCC, 0x64
}; 

const uint8_t totem[] = {
0x00, 0x00, 0x04, 0x40, 0x04, 0x40, 0x00, 0x00, 
0x00, 0x00, 0x07, 0xC4, 0x49, 0x90, 0x00, 0x00, 
0x00, 0x04, 0x0D, 0x19, 0x91, 0xD0, 0x40, 0x00, 
0x00, 0x58, 0x6C, 0xB7, 0x7B, 0xC6, 0x85, 0x00, 
0x00, 0x58, 0xB6, 0x7D, 0xD7, 0x6B, 0x84, 0x00, 
0x47, 0x44, 0x88, 0xDB, 0x3D, 0x88, 0xC4, 0x74, 
0xCB, 0x87, 0x76, 0x8B, 0xB8, 0x67, 0x98, 0xBC, 
0x0C, 0xD7, 0xCE, 0x6B, 0x86, 0xE6, 0x7D, 0xC0, 
0x58, 0x98, 0x79, 0x7B, 0xB7, 0x97, 0x89, 0x85, 
0x5B, 0x78, 0xBB, 0x79, 0x97, 0xBB, 0x87, 0xBC, 
0x46, 0x78, 0x96, 0xC8, 0x8C, 0x67, 0x87, 0x64, 
0xC7, 0x7B, 0x54, 0x41, 0x14, 0x44, 0xB7, 0x7C, 
0x57, 0x7D, 0x64, 0x87, 0x78, 0x4C, 0x87, 0x75, 
0x04, 0x7B, 0x89, 0x8B, 0xD8, 0x7D, 0xB7, 0x40, 
0x47, 0x77, 0xB7, 0x7B, 0xB7, 0x78, 0x77, 0x74, 
0x47, 0x76, 0x70, 0xC7, 0x7C, 0x47, 0x67, 0x74
}; 

const uint8_t door[] = {
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x22, 0x22, 0x22, 0x2A, 
0x00, 0x0A, 0x10, 0x00, 0x2A, 0xA1, 0x51, 0xA1, 
0xAA, 0xAA, 0xAA, 0xAA, 0x2A, 0xA5, 0x55, 0x21, 
0x11, 0x11, 0x11, 0x11, 0x2A, 0xAA, 0x4A, 0xA1, 
0x00, 0x01, 0x50, 0x00, 0x2A, 0xA1, 0x51, 0xA1, 
0x00, 0x0A, 0x50, 0x00, 0xA1, 0x11, 0xA1, 0x11, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x01, 0x50, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x0A, 0x10, 0x00, 0x00, 0x0A, 0x10, 0x00, 
0x00, 0x05, 0x50, 0x00, 0x00, 0x05, 0x50, 0x00
}; 

const uint8_t key[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x07, 0x77, 0x77, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x7B, 0xBB, 0xBB, 0x70, 0x00, 0x00, 
0x00, 0x07, 0xBB, 0xB7, 0xBB, 0xB7, 0x00, 0x00, 
0x00, 0x07, 0xBB, 0x70, 0x7B, 0xB7, 0x00, 0x00, 
0x00, 0x07, 0xB7, 0x00, 0x07, 0xB7, 0x00, 0x00, 
0x00, 0x07, 0xBB, 0x70, 0x7B, 0xB7, 0x00, 0x00, 
0x00, 0x00, 0x7B, 0xB7, 0xBB, 0x70, 0x00, 0x00, 
0x00, 0x00, 0x07, 0xBB, 0xB7, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7B, 0xB0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7B, 0xB0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7B, 0xBB, 0xB7, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7B, 0xBB, 0xB7, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7B, 0xB7, 0x77, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x77, 0x70, 0x00, 0x00, 0x00
}; 

const uint8_t ladder[] = {
0x67, 0xB6, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x86, 
0x87, 0x87, 0xB7, 0x88, 0x88, 0x87, 0xB7, 0x87, 
0x7B, 0x7B, 0x7B, 0xBB, 0xBB, 0xBB, 0x7B, 0x7B, 
0x78, 0xB7, 0x88, 0x88, 0x88, 0x88, 0x87, 0xB8, 
0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x78, 0x77, 
0x66, 0x79, 0x66, 0x66, 0x66, 0x66, 0x67, 0x66, 
0x67, 0x86, 0x00, 0x00, 0x00, 0x00, 0x68, 0x76, 
0x68, 0x76, 0x00, 0x00, 0x00, 0x00, 0x67, 0xB6, 
0x67, 0xB6, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x86, 
0x87, 0x87, 0xB7, 0x88, 0x88, 0x87, 0xB7, 0x87, 
0x7B, 0x7B, 0x7B, 0xBB, 0xBB, 0xBB, 0x7B, 0x7B, 
0x78, 0xB7, 0x88, 0x88, 0x88, 0x88, 0x87, 0xB8, 
0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x78, 0x77, 
0x66, 0x76, 0x66, 0x66, 0x66, 0x66, 0x67, 0x66, 
0x67, 0x86, 0x00, 0x00, 0x00, 0x00, 0x68, 0x76, 
0x68, 0x76, 0x00, 0x00, 0x00, 0x00, 0x67, 0x76
}; 

const uint8_t left[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x09, 0x90, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x9B, 0xB0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x99, 0xBB, 0xB9, 0x99, 0x99, 0x99, 0x00, 
0x09, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xB9, 0x00, 
0x00, 0x99, 0xBB, 0xB9, 0x99, 0x99, 0x99, 0x00, 
0x00, 0x00, 0x9B, 0xB0, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x09, 0x90, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x99, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x66, 0x00, 0x00, 0x00 
};

const uint8_t rick_happy[] = {
0x00, 0x00, 0x57, 0x89, 0x87, 0x60, 0x00, 0x00, 
0x00, 0x40, 0x9D, 0x8D, 0x8B, 0x74, 0x40, 0x00, 
0x04, 0x97, 0x77, 0xD7, 0x78, 0x77, 0x95, 0x00, 
0x00, 0x44, 0x69, 0x69, 0x96, 0x65, 0x50, 0x00, 
0x47, 0x04, 0xBB, 0xDB, 0x8B, 0xB1, 0x00, 0x00, 
0xD8, 0xD0, 0xBD, 0xA2, 0x21, 0xB1, 0x00, 0x00, 
0xDB, 0xD6, 0xBA, 0xDB, 0xD1, 0xB9, 0x44, 0x40, 
0x5D, 0xC7, 0x5B, 0xBB, 0xBB, 0x17, 0x9D, 0x84, 
0x00, 0x49, 0x45, 0x12, 0xA1, 0x46, 0x8B, 0xD1, 
0x00, 0x04, 0x56, 0x77, 0x79, 0xC5, 0x4B, 0xD0, 
0x00, 0x04, 0x97, 0x76, 0x77, 0x95, 0x00, 0x00, 
0x00, 0x21, 0x69, 0xC4, 0xC9, 0x64, 0x25, 0x00, 
0x01, 0x12, 0x51, 0x40, 0x05, 0x1A, 0xA1, 0x40, 
0x00, 0x11, 0x14, 0x00, 0x04, 0x51, 0x15, 0x00, 
0x00, 0x41, 0x50, 0x00, 0x00, 0x51, 0x50, 0x00, 
0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00
};

const uint8_t wall[] = {
0xAA, 0x11, 0x01, 0xA2, 0xAA, 0x10, 0xAA, 0x10, 
0x01, 0x10, 0x00, 0x1A, 0xA1, 0x0A, 0x2A, 0x11, 
0x00, 0x1A, 0x2A, 0x10, 0x00, 0x12, 0xAA, 0x11, 
0x00, 0xA2, 0x32, 0xA1, 0x01, 0xA2, 0xAA, 0x10, 
0x00, 0xA2, 0x2A, 0xA1, 0x0A, 0x2A, 0xA1, 0x10, 
0xA1, 0x0A, 0xAA, 0x11, 0x0A, 0x2A, 0x11, 0x0A, 
0x2A, 0x10, 0x11, 0x10, 0x01, 0xA1, 0x01, 0xA2, 
0x2A, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x23, 
0xAA, 0x10, 0x0A, 0xAA, 0x10, 0x00, 0xA2, 0x33, 
0xA1, 0x10, 0xA2, 0x2A, 0x11, 0x10, 0xA2, 0x32, 
0xA1, 0x0A, 0x22, 0xAA, 0xA1, 0x10, 0x1A, 0x32, 
0x11, 0x1A, 0x23, 0x2A, 0xAA, 0x11, 0x0A, 0x2A, 
0x10, 0x1A, 0x22, 0xA2, 0xAA, 0x11, 0x01, 0xAA, 
0x00, 0x0A, 0xA2, 0x2A, 0xAA, 0x11, 0x00, 0x11, 
0xAA, 0x11, 0xA2, 0x32, 0xAA, 0x11, 0x00, 0x01, 
0x5A, 0xA1, 0x1A, 0x22, 0xA1, 0x10, 0x00, 0x1A
}; 


const uint16_t palette[] = {
    0x0000,0x4A49,0x9492,0xB5B6,
    0x10C2,0x2144,0x4920,0x8A60,
    0xC380,0x59A0,0x6B6D,0xF46B,
    0x3101,0xA32A,0x2589,0x9CF3
};

const uint16_t palette_orange[] = {0x0000, 0x61a0, 0xcb41, 0xf423 };

const uint8_t rick_font[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xE4, 0x07, 0xC0, 0x1B, 0xE4, 0x1B, 0xE4,
    0x07, 0xF0, 0x3F, 0xFC, 0x06, 0xE0, 0x3F, 0xFC, 0x1B, 0xE4, 0x1B, 0xE4, 0xBF, 0xFE, 0x00, 0x00,
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xE4, 0x00, 0x00, 0x02, 0xE0, 0x3F, 0xE4, 0x1B, 0xE4,
    0x3F, 0xE4, 0x3F, 0xFC, 0x3F, 0xFC, 0x1B, 0xE4, 0x3C, 0x3C, 0x0B, 0xE0, 0x0B, 0xE0, 0x3C, 0xBD,
    0x3E, 0x00, 0x39, 0x1B, 0x38, 0x2C, 0x1B, 0xE4, 0x3F, 0xE4, 0x1B, 0xE4, 0x3F, 0xE4, 0x1B, 0xE4,
    0x3F, 0xFC, 0x3C, 0x3C, 0x3C, 0x0F, 0x3C, 0x0F, 0x3C, 0x3C, 0x38, 0x2C, 0x3F, 0xFC, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2C, 0x38, 0x0B, 0xC0, 0x2D, 0x38, 0x2D, 0x38, 0x1F, 0xF0,
    0x3C, 0x18, 0x1B, 0x40, 0x24, 0x7C, 0x2C, 0x38, 0x2C, 0x38, 0x6A, 0xA9, 0x00, 0x00, 0x1B, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x2D, 0x38, 0x00, 0x00, 0x07, 0xF4, 0x3C, 0x38, 0x2D, 0x38, 0x3C, 0x78,
    0x3C, 0x18, 0x3C, 0x18, 0x2D, 0x38, 0x3C, 0x3C, 0x03, 0xC0, 0x03, 0xC0, 0x3E, 0xF4, 0x3D, 0x00,
    0x3E, 0x6F, 0x3E, 0x3C, 0x2C, 0x38, 0x3C, 0x38, 0x2C, 0x38, 0x3C, 0x38, 0x2C, 0x38, 0x27, 0xD8,
    0x3C, 0x3C, 0x3C, 0x0F, 0x3C, 0x0F, 0x2D, 0x78, 0x2C, 0x38, 0x24, 0x7C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3C, 0x3C, 0x03, 0xC0, 0x00, 0x78, 0x00, 0x38, 0x78, 0xF0, 0x3C, 0x00,
    0x2D, 0x00, 0x01, 0xB4, 0x2C, 0x38, 0x2C, 0x3C, 0x15, 0x54, 0x00, 0x00, 0x6F, 0xFC, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x0B, 0x38, 0x3C, 0x38, 0x3C, 0x00, 0x3C, 0x3C, 0x3C, 0x00,
    0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x3C, 0x03, 0xC0, 0x03, 0xC0, 0x3F, 0xD0, 0x3C, 0x00, 0x3F, 0xBF,
    0x3F, 0xBC, 0x3C, 0x3C, 0x3C, 0x38, 0x3C, 0x3C, 0x3C, 0x38, 0x2D, 0x00, 0x03, 0xC0, 0x3C, 0x3C,
    0x2C, 0x0E, 0x3C, 0x4F, 0x1E, 0xB4, 0x1F, 0xF4, 0x01, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3C, 0x3C, 0x03, 0xC0, 0x01, 0xE4, 0x02, 0xF4, 0xF0, 0xF0, 0x3F, 0xF4, 0x3F, 0xE4,
    0x02, 0xD0, 0x1F, 0xF4, 0x1B, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xFC, 0x00, 0x00, 0x00, 0x00,
    0x01, 0xE4, 0x00, 0x00, 0x0F, 0x3C, 0x3F, 0xF4, 0x3C, 0x00, 0x3C, 0x3C, 0x3F, 0xE0, 0x3F, 0xE0,
    0x3C, 0x00, 0x3F, 0xFC, 0x03, 0xC0, 0x03, 0xC0, 0x3F, 0x40, 0x3C, 0x00, 0x3D, 0xDF, 0x3F, 0xFC,
    0x3C, 0x3C, 0x3F, 0xF4, 0x3C, 0xBC, 0x3F, 0xF4, 0x1B, 0xE4, 0x03, 0xC0, 0x3C, 0x3C, 0x1F, 0x3D,
    0x3D, 0xDF, 0x07, 0xD0, 0x07, 0xD0, 0x07, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3C, 0x3C, 0x03, 0xC0, 0x07, 0x90, 0x00, 0x38, 0xFF, 0xF8, 0x00, 0x38, 0x3C, 0x38, 0x03, 0xC0,
    0x2C, 0x38, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x02, 0xD0,
    0x00, 0x00, 0x1F, 0xFD, 0x3C, 0x38, 0x3C, 0x00, 0x3C, 0x3C, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0xBC,
    0x3C, 0x3C, 0x03, 0xC0, 0x03, 0xC0, 0x3F, 0xD0, 0x3C, 0x00, 0x3C, 0x4F, 0x3E, 0xFC, 0x3C, 0x3C,
    0x3C, 0x00, 0x3C, 0xEC, 0x3F, 0xD0, 0x00, 0x78, 0x03, 0xC0, 0x3C, 0x3C, 0x0B, 0x38, 0x3F, 0xBF,
    0x1E, 0xB4, 0x03, 0xC0, 0x1F, 0x40, 0x03, 0xC0, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x2C, 0x38,
    0x03, 0xC0, 0x1E, 0x48, 0x2D, 0x38, 0x00, 0xF0, 0x2D, 0x38, 0x2C, 0x38, 0x03, 0xC0, 0x2C, 0x38,
    0x01, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x2C, 0x0E, 0x3C, 0x38, 0x2D, 0x38, 0x3C, 0x78, 0x3C, 0x18, 0x3C, 0x00, 0x2D, 0x38, 0x3C, 0x3C,
    0x03, 0xC0, 0x07, 0x80, 0x3E, 0xF4, 0x3C, 0x18, 0x3C, 0x0F, 0x3C, 0xBC, 0x2C, 0x38, 0x3C, 0x00,
    0x2C, 0x74, 0x3E, 0xF4, 0x2C, 0x38, 0x03, 0xC0, 0x2C, 0x38, 0x07, 0xF4, 0x3E, 0x6F, 0x2D, 0x78,
    0x03, 0xC0, 0x3D, 0x18, 0x03, 0x80, 0x00, 0x00, 0x0F, 0x40, 0x00, 0x00, 0x1B, 0xE4, 0x0B, 0xE0,
    0x3F, 0xFC, 0x1B, 0xE4, 0x02, 0xF8, 0x1B, 0xE4, 0x1B, 0xE4, 0x0B, 0xE0, 0x1B, 0xE4, 0x0B, 0x90,
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xD0, 0x00, 0x00, 0x3C, 0x0F,
    0x3F, 0xE4, 0x1B, 0xE4, 0x3F, 0xE4, 0x3F, 0xFC, 0x3C, 0x00, 0x1B, 0xE4, 0x3C, 0x3C, 0x0B, 0xE0,
    0x2E, 0x40, 0x3C, 0xBD, 0x3F, 0xFC, 0x3C, 0x0F, 0x38, 0x2C, 0x1B, 0xE4, 0x3C, 0x00, 0x1B, 0xDC,
    0x3C, 0xBD, 0x1B, 0xE4, 0x0B, 0xE0, 0x1B, 0xE4, 0x02, 0xE0, 0x39, 0x1B, 0x3C, 0x3C, 0x0B, 0xE0,
    0x3F, 0xFC, 0x0E, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


struct Image {
public:    
    bool Mirrored;
    bool Transparent;
    const uint8_t * Sprite;
};

extern Image sprites[];

void drawChar(int x, int y, char c, const uint16_t *palette);
void drawSprite(int x, int y, int sprite);
void drawString(int x, int y, const char *pString, const uint16_t *palette);
void drawLevelNumber(int x, int y, int level);
#endif //__SPRITES_H__