/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the "Lost treasure of mBedungu" game application for Retro
 *
 * The "Lost treasure of mBedungu" application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */
 
#include "mbed.h"
#include "IntroScreen.h"
#include "Sprites.h"

#include "Retro.h"

const int letter_tick[8] = {
    0,1,57,0,0,0,7,1
};

char title[] = {
    "@SOMEWHERE@IN@SOUTH@\r\n" \
    "@@@@@@@AMERICA@@@@@@"
};

char text1[] = {
    "RICK@IS@ON@A@MISSION\r\n" \
    "@@TO@FIND@100@LOST@@\r\n" \
    "@@@@TOTEMS@OF@THE@@@\r\n" \
    "@@@MBEDUNGU@TRIBE@@@"
};

char text2[] = {
    "@@LEGEND@SAYS@THAT@@\r\n" \
    "@@@THE@TOTEMS@ARE@@@\r\n" \
    "@@@@HIDDEN@IN@AN@@@@\r\n" \
    "@@UNDERGROUND@MAZE@@"
};

char text3[] = {
    "FINDING@THE@ENTRANCE\r\n" \
    "TO@THE@MAZE@WAS@EASY\r\n" \
    "@@@BUT@WHAT@AWAITS@@\r\n" \
    "@@@@@@@AHEAD?@@@@@@@"
};

char * texts[] = {
    text1,
    text2,
    text3
};

extern Retro retro;

IntroScreen::IntroScreen()
{
    _state = 0;
}

char * pText = text1;
int curText = 0;
int y = 80;
int x = 0;
int frame = 0;
Screen IntroScreen::Update()
{
    if( _state == 0 ) {
        retro.display.clearScreen();
        drawString(0,0, title, palette);
        _state = 1;
        pText = text1;
        curText = 0;
        y=80;
        x=0;
        frame = 0;

        drawSprite(4,3,12);
        drawSprite(5,3,9);


        retro.display.fillRect(0,80,159,127,0);

    } else if( _state == 1 ) {
        frame++;

        if( (frame % 3) == 0 ) {
            sprites[12].Mirrored = !sprites[12].Mirrored;
            drawSprite(4,3,12);
        }

        if( (frame % 2) == 0 ) {

            //frame = 0;

            if( *pText != 0 ) {

                while( *pText == '@' ) {
                    drawChar(x, y, *pText++, palette);
                    x+=8;
                }


                if( *pText == 0 )
                    _state = 2;
                else {

                    if( *pText == 13 ) {
                        x = 0;
                        pText++;
                    } else if( *pText == 10 ) {
                        y += 8;
                        pText++;
                    } else {
                        sfx(letter_tick,0);

                        drawChar(x, y, *pText++, palette);
                        x+=8;
                    }
                }
            } else
                _state = 2;
        }
    }

    if(retro.pressed(BTN_ROBOT)) {
        _state = 0;
        return Game;

    }

    if(retro.pressed(BTN_SHIP)) {
        if( _state == 1 ) {
            drawString(0, 80, texts[curText], palette);
            _state = 2;
        } else if( _state == 2 ) {
            if( curText < 2 ) {
                curText++;
                pText = texts[curText];
                y=80;
                x=0;
                frame = 0;
                _state = 1;
                retro.display.fillRect(0,80,159,127,0);
            } else {
                _state = 0;
                return Game;
            }
        }
    }

    return Intro;
}