/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the "Lost treasure of mBedungu" game application for Retro
 *
 * The "Lost treasure of mBedungu" application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */
 
#ifndef __GAME_SCREEN_H__
#define __GAME_SCREEN_H__

#include "mbed.h"
#include "ScreenBase.h"

#define CELL_EMPTY      0
#define CELL_WALL       1
#define CELL_BARREL     2
#define CELL_LADDER     3
#define CELL_KEY        4
#define CELL_DOOR       5
#define CELL_LEFT       6
#define CELL_RIGHT      7
#define CELL_CRATE      8
#define CELL_TOTEM      9
#define CELL_RICK       10
#define CELL_TOP        11
#define CELL_HAPPY      12



class GameScreen : public ScreenBase
{
    int _state;
    
    uint8_t _maze[64];
    uint8_t _pocket[2];
    
    uint8_t _rickX;
    uint8_t _rickY;
    
    uint8_t _totemX;
    uint8_t _totemY;
    uint8_t _level; 
    uint8_t _rickDirection;   
    
    bool _gameOver;
    bool _gameComplete;
    
    int frame;
    
    
    char _gameData[8];
public:
    GameScreen();
    virtual Screen Update();

    void unpackLevel( int level );
    void resetLevel();
    uint8_t getLevel(){ return _level; };
private:
    
    void next();
    void moveleft();
    void moveright();
    void moveup();
    void movedown();
    
    bool moveto(uint8_t fromX, uint8_t fromY, uint8_t toX, uint8_t toY);
    bool fall(uint8_t fromX, uint8_t fromY);
        
    bool isPocketFull();
    bool isPocketEmpty();
    bool putInPocket( int item );
    bool getKeyFromPocket();
    bool getBarrelFromPocket();
           
    void drawPocket();    
    void drawLevel();    
};

#endif //__GAME_SCREEN_H_