/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the "Lost treasure of mBedungu" game application for Retro
 *
 * The "Lost treasure of mBedungu" application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */
 
#include "mbed.h"
#include "MenuScreen.h"
#include "GameScreen.h"
#include "LevelScreen.h"
#include "Retro.h"
#include "Sprites.h"

char options[][13] = {
    "BACK@@@@@@@@",
    "INTRO@@@@@@@",
    "RESET@@LEVEL",
    "SELECT@LEVEL",
};

extern Retro retro;
extern GameScreen * pGameScreen;
extern LevelScreen * pLevelScreen;

MenuScreen::MenuScreen()
{
    _oldSelection = 0;
    _selection = 0;
    _state = 0;
}

Screen MenuScreen::Update()
{
    if( _state == 0 ) {
        int y = 32+4;

        retro.display.clearScreen();

        for( int i = 0; i<4; i++) {
            drawString(8+16, y, options[i], palette);
            y+=16;
        }
        _state = 1;
    } else if( _state == 1 ) {
        
        int y = 32 + 16*_oldSelection;
               retro.display.fillRect(8,y, 8+15,y+15,0);
 
        retro.display.drawBitmapIndexed(8,32 + 16*_selection, 16, 16, totem, palette);
        _state = 2;
    }

    if(retro.pressed(BTN_UP)) {
        _oldSelection = _selection;
        if(_selection == 0)
            _selection = 3;
        else
            _selection--;
        _state = 1;
    }
    if(retro.pressed(BTN_DOWN)) {
        _oldSelection = _selection;
        if(_selection == 3)
            _selection = 0;
        else
            _selection++;
        _state = 1;
    }
    if(retro.pressed(BTN_SHIP)) {
        
        _state = 0;
        if( _selection == 0 )
            return Game;
        if( _selection == 1 )
            return Intro;
        if( _selection == 2 )
        {
            if( pGameScreen )
                pGameScreen->resetLevel();
            return Game;            
        }
        if( _selection == 3 )
        {
            if( pLevelScreen == NULL )
                pLevelScreen = new LevelScreen();
            pLevelScreen->GameLevel = pGameScreen->getLevel();
                        
            return Level;
        }
    }
    return Menu;
}