/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the "Lost treasure of mBedungu" game application for Retro
 *
 * The "Lost treasure of mBedungu" application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */
 
#include "mbed.h"
#include "LevelScreen.h"
#include "GameScreen.h"
#include "Retro.h"
#include "Color565.h"
#include "Sprites.h"


extern Retro retro;
extern GameScreen * pGameScreen;

LevelScreen::LevelScreen()
{
    _state = 0;
}




Screen LevelScreen::Update()
{
    int x  = 68;
    int y = 60;

    if( _state == 0 ) {

        retro.display.clearScreen();
        drawString(0,0,"@@@@SELECT@LEVEL@@@@", palette);
        drawLevelNumber(x,y,GameLevel);

        _state = 1;
    }

    if(retro.pressed(BTN_SHIP)) {
        _state = 0;
        pGameScreen->unpackLevel(GameLevel);
        return Game;
    } else if( retro.pressed(BTN_ROBOT)) {
        _state = 0;
        return Game;
    }


    if(retro.pressed(BTN_UP)) {

        GameLevel+=5;
        if( GameLevel > 99 )
            GameLevel = 99;

        drawLevelNumber(x,y,GameLevel);

    } else if(retro.pressed(BTN_DOWN)) {
        GameLevel-=5;
        if( GameLevel < 0 )
            GameLevel = 0;

        drawLevelNumber(x,y,GameLevel);

    } else if(retro.pressed(BTN_LEFT)) {
        GameLevel--;
        if( GameLevel < 0 )
            GameLevel = 0;

        drawLevelNumber(x,y,GameLevel);

    } else if(retro.pressed(BTN_RIGHT)) {
        GameLevel++;
        if( GameLevel > 99 )
            GameLevel = 99;

        drawLevelNumber(x,y,GameLevel);
    }


    return Level;
}