/*
 * (C) Copyright 2015 Valentin Ivanov. All rights reserved.
 *
 * This file is part of the "Lost treasure of mBedungu" game application for Retro
 *
 * The "Lost treasure of mBedungu" application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */
 
#include "mbed.h"
#include "Retro.h"
#include "GameScreen.h"
#include "Levels.h"
#include "Sprites.h"
#include "Utils.h"

#include "IntroScreen.h"
#include "MenuScreen.h"
#include "LevelScreen.h"


IntroScreen * pIntroScreen = NULL;
MenuScreen * pMenuScreen = NULL;
GameScreen * pGameScreen = NULL;
LevelScreen * pLevelScreen = NULL;

Retro retro;

uint8_t * pRickFont = NULL;

void unpackFont()
{
    pRickFont = (uint8_t *)malloc(376*8);
    
    if( pRickFont == NULL )
        retro.rightEye = true;
        
    memset(pRickFont,0,376*8);
    //return;
    
    if( pRickFont != NULL )
    {
        for(int i = 0; i < 752; i++)
        {
            pRickFont[(i<<2)+0] = (rick_font[i]>>6) & 0x03;
            pRickFont[(i<<2)+1] = (rick_font[i]>>4) & 0x03;
            pRickFont[(i<<2)+2] = (rick_font[i]>>2) & 0x03;
            pRickFont[(i<<2)+3] = (rick_font[i]) & 0x03;
        }
    }
}

void drawChar(int x, int y, char c, const uint16_t *palette)
{
    if( pRickFont == NULL )
        return;
        
    int index = c-44;
    retro.display.drawBitmapIndexed(x,y,376,8,index*8,0,8,8,pRickFont, palette);
}
void drawString(int x, int y, const char *pString, const uint16_t *palette)
{
    int i = 0;
    char *p = (char*)pString;
    while(*p != 0)
    {
        if( *p == 13 )
        {
            i = 0;
            p++;
            continue;
        }
        if( *p == 10 )
        {
            y += 8;
            p++;
            continue;
        }
                
        drawChar(x + i*8, y, *p++, palette);
        i++;
    }
}

main()
{
    
    unpackFont();
    
    retro.initialize();
        
    pGameScreen = new GameScreen();
    pGameScreen->resetLevel();

    Screen currentScreen = Intro;

    while (true) {
        if( retro.update() ) {

            switch( currentScreen ) {
                case Intro:
                    if( pIntroScreen == NULL )
                        pIntroScreen = new IntroScreen();
                    currentScreen = pIntroScreen->Update();
                    break;
                case Menu:
                    if( pMenuScreen == NULL )
                        pMenuScreen = new MenuScreen();
                    currentScreen = pMenuScreen->Update();
                    break;
                case Game:
                    currentScreen = pGameScreen->Update();
                    break;
                case Level:
                    if( pLevelScreen == NULL )
                        pLevelScreen = new LevelScreen();
                    currentScreen = pLevelScreen->Update();
                    break;
            }
        }
    }
}
