/*
 * main.c - sample application to switch to AP mode and ping client
 *
 * Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Application Name     -   Getting started with Wi-Fi Access-Point mode
 * Application Overview -   This sample application accessPointnstrates how
 *                          to configure CC3100 in Access-Point mode. Any
 *                          WLAN station in its range can connect/communicate
 *                          to/with it as per the standard networking protocols.
 *                          On a successful connection, the device ping's the
 *                          connected station.
 * Application Details  -   http://processors.wiki.ti.com/index.php/CC31xx_Getting_Started_with_WLAN_AP
 *                          doc\examples\getting_started_with_wlan_ap.pdf
 */

#include "mbed.h"
#include "cc3100_simplelink.h"
#include "cc3100_sl_common.h"

#include "fPtr_func.h"
#include "cc3100.h"
#include "cc3100_spi.h"
#include "myBoardInit.h"
#include <string.h>

using namespace mbed_cc3100;

#if (THIS_BOARD == MBED_BOARD_LPC4337)
//cc3100 _cc3100(p9, p10, p8, SPI(p5, p6, p7));//LPC1768  irq, nHib, cs, mosi, miso, sck
cc3100 _cc3100(P2_2, P3_5, P1_5, SPI(P1_4, P1_3, PF_4));//LPC4337  irq, nHib, cs, mosi, miso, sck
Serial pc(USBTX, USBRX);//lpc4337
#elif (THIS_BOARD == MBED_BOARD_LPC1768)
//cc3100 _cc3100(p9, p10, p8, SPI(p5, p6, p7));//LPC1768  irq, nHib, cs, mosi, miso, sck
cc3100 _cc3100(p9, p10, p8, SPI(p11, p12, p13));//LPC1768  irq, nHib, cs, mosi, miso, sck
Serial pc(USBTX, USBRX);//lpc1768
#elif (THIS_BOARD == ST_MBED_NUCLEOF411)
cc3100 _cc3100(PA_9, PC_7, PB_6, SPI(PA_7, PA_6, PA_5));//nucleoF411  irq, nHib, cs, mosi, miso, sck
Serial pc(SERIAL_TX, SERIAL_RX);//nucleoF411
#elif (THIS_BOARD == ST_MBED_NUCLEOF401)
cc3100 _cc3100(PA_9, PC_7, PB_6, SPI(PA_7, PA_6, PA_5));//nucleoF401  irq, nHib, cs, mosi, miso, sck
Serial pc(SERIAL_TX, SERIAL_RX);//nucleoF401
#elif (THIS_BOARD == EA_MBED_LPC4088)
cc3100 _cc3100(p9, p10, p8, SPI(p5, p6, p7));//LPC4088  irq, nHib, cs, mosi, miso, sck
Serial pc(USBTX, USBRX);//EA_lpc4088
#elif (THIS_BOARD == ST_MBED_NUCLEOF103)
cc3100 _cc3100(PA_9, PC_7, PB_6, SPI(PA_7, PA_6, PA_5));//nucleoF103  irq, nHib, cs, mosi, miso, sck
Serial pc(SERIAL_TX, SERIAL_RX);
#elif (THIS_BOARD == Seeed_Arch_Max)
cc3100 _cc3100(PD_12, PD_13, PD_11, SPI(PB_5, PB_4, PB_3));//Seeed_Arch_Max  irq, nHib, cs, mosi, miso, sck
Serial pc(USBTX, USBRX);
#else
#endif

/* Indirizzo IP del server, bisogna usare il formato long esadecimale
 * E.g: 0xc0a8010a == 192.168.1.1 */
#define IP_ADDR         0xc0a80101
#define PORT_NUM        5000

#define BUF_SIZE        1400
#define NO_OF_PACKETS   1000
/*
 * GLOBAL VARIABLES -- Start
 */
int32_t accessPoint = 1;

/*
 * GLOBAL VARIABLES -- End
 */

/*
 * STATIC FUNCTION DEFINITIONS -- Start
 */

static void displayBanner();
/*
 * STATIC FUNCTION DEFINITIONS -- End
 */
 
void station_app(void);
void AP_app(void);

DigitalOut myled1(LED1);//Azzurro
DigitalOut myled2(LED2);//Giallo
DigitalOut myled3(LED3);//Viola

void white() {
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
}

void ledShow() {
    while(1) {
        myled1 = 1;
        myled2 = 1;
        myled3 = 1;
        wait(5);
        myled1 = 0;
        wait(5);
        myled1 = 1;
        myled2 = 0;
        wait(5);
        myled2 = 1;
        myled3 = 0;
        wait(5);
        myled2 = 0;
        wait(5);
        myled1 = 0;
        myled2 = 1;
        wait(5);
        myled2 = 0;
        myled3 = 1;
        wait(5);
        myled3 = 0;
        wait(5);
    }
}
 
int main(void) {

    myled1 = 1;
    myled2 = 1;
    myled3 = 1;
    pc.baud(115200);

    int32_t retVal = -1;

    retVal = _cc3100.initializeAppVariables();
    ASSERT_ON_ERROR(retVal);

    displayBanner();

    _cc3100.CLR_STATUS_BIT(g_Status, STATUS_BIT_PING_DONE);
    g_PingPacketsRecv = 0;
    
    /*
     * Following function configures the device to default state by cleaning
     * the persistent settings stored in NVMEM (viz. connection profiles &
     * policies, power policy etc)
     *
     * Applications may choose to skip this step if the developer is sure
     * that the device is in its default state at start of application
     *
     * Note that all profiles and persistent settings that were done on the
     * device will be lost
     */
    retVal = _cc3100.configureSimpleLinkToDefaultState();
    
    if(retVal < 0) {
        if (DEVICE_NOT_IN_STATION_MODE == retVal)
            printf(" Impossibile completare la configurazione della CC3100 \n\r");

        LOOP_FOREVER();
    }

    printf(" CC3100 configurata nel suo stato di default \n\r");
    
    /*
     * Assumption is that the device is configured in station mode already
     * and it is in its default state
     */
    /* Initializing the CC3100 device */
    
    if(!accessPoint){
        retVal = _cc3100.sl_Start(0, 0, 0);
    
        if ((retVal < 0) || (ROLE_STA != retVal) ){
        printf(" Impossibile avviare la CC3100 nella modalita' richiesta \n\r");
        LOOP_FOREVER();
        }

        printf(" CC3100 avviata come scheda di rete \n\r");
    }
    
    if(accessPoint == 0 ){
       station_app();
    }else{
       AP_app(); 
    }    
    return 0;
}    

/*!
    \brief This function displays the application's banner

    \param      None

    \return     None
*/
static void displayBanner()
{
    //int choose;
    
    if(accessPoint){
        printf("\n\r\n\r");
        printf(" CC3100 in avvio come Access Point ");
        printf("\n\r*******************************************************************************\n\r");
        //ledShow();
        //scanf("%s", &choose);
        //printf("\n\r%d\n\r", choose);
    
    }else{
         printf("\n\r\n\r");
         printf(" CC3100 in avvio come scheda di rete ");
         printf("\n\r*******************************************************************************\n\r");
    }
}

int32_t TcpServer(uint16_t Port)
{
    SlSockAddrIn_t  Addr;
    SlSockAddrIn_t  LocalAddr;
    char buf[100], tmp[100];
    int i, len;

    int16_t       AddrSize = 0;
    int16_t       SockID = 0;
    int32_t       Status = 0;
    int16_t       newSockID = 0;
    uint16_t      LoopCount = 0;
    int16_t       recvSize = 0;

    LocalAddr.sin_family = SL_AF_INET;
    LocalAddr.sin_port = _cc3100._socket.sl_Htons((int16_t)Port);
    LocalAddr.sin_addr.s_addr = 0;

    SockID = _cc3100._socket.sl_Socket(SL_AF_INET,SL_SOCK_STREAM, 0);
    if( SockID < 0 )
    {
        printf(" Errore durante la creazione del socket \n\r");
        ASSERT_ON_ERROR(SockID);
    }

    AddrSize = sizeof(SlSockAddrIn_t);
    Status = _cc3100._socket.sl_Bind(SockID, (SlSockAddr_t *)&LocalAddr, AddrSize);
    if( Status < 0 )
    {
        _cc3100._socket.sl_Close(SockID);
        printf(" Errore durante il bind della porta \n\r");
        ASSERT_ON_ERROR(Status);
    }

    Status = _cc3100._socket.sl_Listen(SockID, 0);
    if( Status < 0 )
    {
        _cc3100._socket.sl_Close(SockID);
        printf(" Errore durante la listen \n\r");
        ASSERT_ON_ERROR(Status);
    }
    
    printf("Socket in attesa di connessioni \n\r");

    newSockID = _cc3100._socket.sl_Accept(SockID, (SlSockAddr_t *)&Addr,
                              (SlSocklen_t*)&AddrSize);
    if( newSockID < 0 )
    {
        _cc3100._socket.sl_Close(SockID);
        printf(" Errore durante la accept \n\r");
        ASSERT_ON_ERROR(newSockID);
    }
    
    printf("Connessione accettata\n\r");

    while (LoopCount < NO_OF_PACKETS)
    {
        recvSize = BUF_SIZE;
        do
        {
            Status = _cc3100._socket.sl_Recv(newSockID, &(buf), recvSize, 0);
            if( Status <= 0 )
            {
                _cc3100._socket.sl_Close(newSockID);
                _cc3100._socket.sl_Close(SockID);
                printf(" Errore in ricezione \n\r");
                ASSERT_ON_ERROR(TCP_RECV_ERROR);
            } else {            
                // Rimuovo i caratteri strani
                for(i = 0; i < strlen(buf); i++) {
                    if((buf[i] >= 65 && buf[i] <= 90) || (buf[i] >= 97 && buf[i] <= 122)){
                        //printf("%c ", buf[i]);
                        len = i + 1;
                    }
                }
                buf[len] = '\0'; 
                printf("Ricevuto -> %s \n\r", buf);
                
                //Scelgo il colore da utilizzare
                if(strstr(buf,"Blu") != NULL || strstr(buf,"blu") != NULL) {
                    white();
                    myled1 = 1;
                    myled3 = 1;
                    sprintf(tmp, "Led colorato di Blu \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Azzurro") != NULL || strstr(buf,"azzurro") != NULL){
                    white();
                    myled1 = 1;
                    sprintf(tmp, "Led colorato di Azzurro \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Rosso") != NULL || strstr(buf,"rosso") != NULL){
                    white();
                    myled2 = 1;
                    myled3 = 1;
                    sprintf(tmp, "Led colorato di Rosso \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Verde") != NULL || strstr(buf,"verde") != NULL){
                    white();
                    myled1 = 1;
                    myled2 = 1;
                    sprintf(tmp, "Led colorato di Verde \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Giallo") != NULL || strstr(buf,"giallo") != NULL){
                    white();
                    myled2 = 1;
                    sprintf(tmp, "Led colorato di Giallo \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Viola") != NULL || strstr(buf,"viola") != NULL){
                    white();
                    myled3 = 1;
                    sprintf(tmp, "Led colorato di Viola \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Bianco") != NULL || strstr(buf,"bianco") != NULL){
                    white();
                    sprintf(tmp, "Led colorato di Bianco \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else if (strstr(buf,"Off") != NULL || strstr(buf,"off") != NULL || strstr(buf,"Nero") != NULL || strstr(buf,"nero") != NULL){
                    myled1 = 1;
                    myled2 = 1;
                    myled3 = 1;
                    sprintf(tmp, "Led spento \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                    
                } else {
                    sprintf(tmp, "Hai inviato un colore non valido \n");
                    _cc3100._socket.sl_Send(newSockID, &(tmp), strlen(tmp),0);
                }
            }

            recvSize -= Status;
        }
        while(recvSize > 0);

        LoopCount++;
    }

    Status = _cc3100._socket.sl_Close(newSockID);
    ASSERT_ON_ERROR(Status);

    Status = _cc3100._socket.sl_Close(SockID);
    ASSERT_ON_ERROR(Status);

    return SUCCESS;
}

void AP_app(void){
    
    SlPingStartCommand_t PingParams = {0};
    SlPingReport_t Report = {0};
//    SlNetCfgIpV4Args_t ipV4 = {0};
//    SlNetAppDhcpServerBasicOpt_t dhcpParams = {0};

    uint8_t SecType = 0;
    int32_t role = ROLE_STA;
    int32_t retVal = -1;
    char answer[20];
    
    /*
     * Assumption is that the device is configured in station mode already
     * and it is in its default state
     */
    role = _cc3100.sl_Start(0, 0, 0);
    if (ROLE_AP == role) {
        /* If the device is in AP mode, we need to wait for this event before doing anything */
        while(!_cc3100.IS_IP_ACQUIRED(g_Status,STATUS_BIT_IP_ACQUIRED)) {
            _cc3100._nonos._SlNonOsMainLoopTask();
        }
    } else {
        /* Configure CC3100 to start in AP mode */
        retVal = _cc3100._wlan.sl_WlanSetMode(ROLE_AP);
        if(retVal < 0)
            LOOP_FOREVER();
            
        /* Configure the SSID of the CC3100 */
        retVal = _cc3100._wlan.sl_WlanSet(SL_WLAN_CFG_AP_ID, WLAN_AP_OPT_SSID,
                strlen(SSID_AP_MODE), (uint8_t *)SSID_AP_MODE);
        if(retVal < 0)
            LOOP_FOREVER();

        SecType = SEC_TYPE_AP_MODE;
        /* Configure the Security parameter the AP mode */
        retVal = _cc3100._wlan.sl_WlanSet(SL_WLAN_CFG_AP_ID, WLAN_AP_OPT_SECURITY_TYPE, 1, (uint8_t *)&SecType);
        if(retVal < 0)
            LOOP_FOREVER();

        retVal = _cc3100._wlan.sl_WlanSet(SL_WLAN_CFG_AP_ID, WLAN_AP_OPT_PASSWORD, strlen(PASSWORD_AP_MODE), (uint8_t *)PASSWORD_AP_MODE);
        if(retVal < 0)
            LOOP_FOREVER();    

        retVal = _cc3100.sl_Stop(SL_STOP_TIMEOUT);
        if(retVal < 0)
            LOOP_FOREVER();

        _cc3100.CLR_STATUS_BIT(g_Status, STATUS_BIT_IP_ACQUIRED);

        role = _cc3100.sl_Start(0, 0, 0);
        if (ROLE_AP == role) {
            /* If the device is in AP mode, we need to wait for this event before doing anything */
            while(!_cc3100.IS_IP_ACQUIRED(g_Status,STATUS_BIT_IP_ACQUIRED)) {
                _cc3100._nonos._SlNonOsMainLoopTask();
            }
        } else {
            printf(" Impossibile completare l'avvio come Access Point \n\r");
            LOOP_FOREVER();
        }
    }
    printf(" Avvio come Access Point completato \n\r");

    /* Wait */
    printf(" In attesa di qualcuno che si connetta\n\r");
    while((!_cc3100.IS_IP_LEASED(g_Status,STATUS_BIT_IP_LEASED)) || (!_cc3100.IS_STA_CONNECTED(g_Status,STATUS_BIT_STA_CONNECTED))) {
        _cc3100._nonos._SlNonOsMainLoopTask();
    }
    printf(" Un client sta tentando di connettersi \n\r");
    /*printf(" In corso test di connettivita'... \n\r");

    // Set the ping parameters 
    PingParams.PingIntervalTime = PING_INTERVAL;
    PingParams.PingSize = PING_SIZE;
    PingParams.PingRequestTimeout = PING_TIMEOUT;
    PingParams.TotalNumberOfAttempts = PING_ATTEMPTS;
    PingParams.Flags = 0;
    PingParams.Ip = g_StationIP; // Fill the station IP address connected to CC3100 

    // Ping client connected to CC3100
    retVal = _cc3100._netapp.sl_NetAppPingStart((SlPingStartCommand_t*)&PingParams, SL_AF_INET, (SlPingReport_t*)&Report, &SimpleLinkPingReport);
    if(retVal < 0)
        LOOP_FOREVER();

    // Wait
    while(!_cc3100.IS_PING_DONE(g_Status,STATUS_BIT_PING_DONE)) {
        _cc3100._nonos._SlNonOsMainLoopTask();
    }

    if (0 == g_PingPacketsRecv) {
        printf(" Impossibile connettersi correttamente al client \n\r");
        //ASSERT_ON_ERROR(LAN_CONNECTION_FAILED);
        printf(" ERRORE numero %d\n\r", LAN_CONNECTION_FAILED);
    }*/

    printf(" Client correttamente connesso \n\r");
    
    //Funzione che gestisce e crea la socket
    sprintf(answer,"si");
    while(1) {
        printf(" Socket in apertura \n\r");
        retVal = TcpServer(PORT_NUM);
        if(retVal < 0)
            printf(" Socket chiuso \n\r");
    }
}

int32_t pingToHost(char* host) {
    
    SlPingStartCommand_t pingParams = {0};
    SlPingReport_t pingReport = {0};

    uint32_t ipAddr = 0;

    int32_t retVal = -1;

    _cc3100.CLR_STATUS_BIT(g_Status, STATUS_BIT_PING_DONE);
    g_PingPacketsRecv = 0;

    /* Set the ping parameters */
    pingParams.PingIntervalTime = PING_INTERVAL;
    pingParams.PingSize = PING_PKT_SIZE;
    pingParams.PingRequestTimeout = PING_TIMEOUT;
    pingParams.TotalNumberOfAttempts = PING_ATTEMPTS;
    pingParams.Flags = 0;
    pingParams.Ip = g_GatewayIP;

    /* Check for Internet connection */
    retVal = _cc3100._netapp.sl_NetAppDnsGetHostByName((unsigned char *)host, strlen(host), &ipAddr, SL_AF_INET);
    if(retVal < 0) {
        printf(" Impossibile trovare l'host \n\r");
        return retVal;
    } else 
        printf(" Avvio ping\n");

    /* Replace the ping address to match HOST_NAME's IP address */
    pingParams.Ip = ipAddr;

    /* Try to ping HOST_NAME */
    retVal = _cc3100._netapp.sl_NetAppPingStart( (SlPingStartCommand_t*)&pingParams, SL_AF_INET,
                                 (SlPingReport_t*)&pingReport, SimpleLinkPingReport);
    if(retVal < 0) {
        printf(" Impossibile connettersi all'host \n\r");
        return retVal;
    }

    /* Wait */
    while(!_cc3100.IS_PING_DONE(g_Status,STATUS_BIT_PING_DONE)) { _cc3100._nonos._SlNonOsMainLoopTask(); }

    if (0 == g_PingPacketsRecv) {
        printf(" Il test non e' andato a buon fine \n\r");
        return retVal;
    }
    
    return 0;

}

void station_app(void) {
    
    int32_t retVal = -1;
    char host[100];
    
    /* Connecting to WLAN AP */
    retVal = _cc3100.establishConnectionWithAP();
    if(retVal < 0)
    {
        printf(" Impossibile connettersi \n\r");
        LOOP_FOREVER();
    }    
    printf(" Connessione stabilita con l'Access Point \n\r");
    
    printf(" Test di connettivita' in corso... \n\r");
    retVal = _cc3100.checkLanConnection();
    if(retVal < 0) {
        printf(" Device couldn't connect to LAN \n\r");
        LOOP_FOREVER();
    }
    printf(" Connesso alla rete locale con successo \r\n");
    
    retVal = _cc3100.checkInternetConnection();
    if(retVal < 0)
    {
        printf(" Device couldn't connect to the internet \n\r");
        LOOP_FOREVER();
    }

    printf(" Connesso ad internet con successo");
    
    // Esegue ping finchè connesso 
    while(1) {
        printf(" \n\rInserire un host a cui fare il ping \n\r");
        scanf("%s", host);
        
        if(pingToHost(host) == 0)
            printf("\nTest completato senza errori\n\r");
        
    }
}              
