#include "mbed.h"
#include "N5110.h"
#include "GameScreen.h"

//initialise function, sets ball pos and creates platforms
void GameScreen::Initialize()
{
    init();         //power up screen and set brightness
    setBrightness(1.0);
    //set ball pos
    playerBall.x = maxX_/2;
    playerBall.y = maxY_ - (int)(maxY_/3 * 2) - 5;

    createAllPlatforms();
}

//draw platform
//  ___________  ________  < y
//               ^ x
void GameScreen::drawPlatform(int x,int y)
{
    for (int a = 0; a < 48; a ++) {
        for (int b = y; b < (y+platThickness_); b++) {
            //skip pixels of gap
            if (a > x && a < (x + platGapSize_))
                break;

            //skip pixels below maxY (lets platforms 'emerge' instead of 'appear')
            if (b > (maxY_ - 1))
                break;

            setPixel(b,a);
        }
    }
}

//erase platform
void GameScreen::erasePlatform(int y)
{
    for (int a = 0; a < 48; a ++) {
        for (int b = y; b < (y+platThickness_); b++) {
            //skip pixels below maxY (lets platforms 'emerge' instead of 'appear')
            if (b > (maxY_ - 1))
                break;

            clearPixel(b,a);
        }
    }
}

//draw the player ball where (x,y) is top right corner.
//      XXP <-- P(x,y)
//     XXXX
//     XXXX
//      XX
void GameScreen::drawBall()
{
    //more elegant ways to do this...but this is most efficient
    setPixel(playerBall.y,playerBall.x+1);
    setPixel(playerBall.y,playerBall.x+2);
    setPixel(playerBall.y+1,playerBall.x);
    setPixel(playerBall.y+1,playerBall.x+1);
    setPixel(playerBall.y+1,playerBall.x+2);
    setPixel(playerBall.y+1,playerBall.x+3);
    setPixel(playerBall.y+2,playerBall.x);
    setPixel(playerBall.y+2,playerBall.x+1);
    setPixel(playerBall.y+2,playerBall.x+2);
    setPixel(playerBall.y+2,playerBall.x+3);
    setPixel(playerBall.y+3,playerBall.x+1);
    setPixel(playerBall.y+3,playerBall.x+2);
}

//draw the player ball where (x,y) is top right corner.
void GameScreen::eraseBall()
{
    clearPixel(playerBall.y,playerBall.x+1);
    clearPixel(playerBall.y,playerBall.x+2);
    clearPixel(playerBall.y+1,playerBall.x);
    clearPixel(playerBall.y+1,playerBall.x+1);
    clearPixel(playerBall.y+1,playerBall.x+2);
    clearPixel(playerBall.y+1,playerBall.x+3);
    clearPixel(playerBall.y+2,playerBall.x);
    clearPixel(playerBall.y+2,playerBall.x+1);
    clearPixel(playerBall.y+2,playerBall.x+2);
    clearPixel(playerBall.y+2,playerBall.x+3);
    clearPixel(playerBall.y+3,playerBall.x+1);
    clearPixel(playerBall.y+3,playerBall.x+2);
}

void GameScreen::createAllPlatforms()
{
    for (int n = 0; n < numPlatforms_ ; n++) {
        //create new platform and add to allPlatform array.
        Platform *newPlatform = new Platform;
        newPlatform->id = n;
        newPlatform->x = rand() % (maxX_-platGapSize_ + 1) - 1;         //randomlly select platform location
        newPlatform->y = maxY_ - n*platSpacing_ - platThickness_ + 1;
        allPlatforms[n] = newPlatform;
    }
}

//Garbage cleanup, free all the platforms!
void GameScreen::freeAllPlatforms()
{
    for (int n = 0; n < numPlatforms_ ; n++) {
        delete allPlatforms[n];
    }
}

void GameScreen::drawAllPlatforms()
{
    for (int n = 0; n < numPlatforms_ ; n++) {
        drawPlatform (allPlatforms[n]->x,allPlatforms[n]->y);
    }
}

void GameScreen::eraseAllPlatforms()
{
    for (int n = 0; n < numPlatforms_ ; n++) {
        erasePlatform (allPlatforms[n]->y);
    }
}

void GameScreen::shiftAllPlatforms(int n )
{
    for (int i = 0; i < numPlatforms_ ; i++) {
        if (allPlatforms[i]->y > (platThickness_+5+n))
            allPlatforms[i]->y = allPlatforms[i]->y - n;
        else {
            allPlatforms[i]->y =  maxY_ - platThickness_ + 1+6; //send back to bottom.
            allPlatforms[i]->x = rand() % (maxX_-platGapSize_ + 1) - 1; //select a new random position of gap!

        }
    }
}

Platform GameScreen::nextClosestPlatform(int y)
{
    int closestY = 100;
    Platform closestPlatform;
    //scan each platform and determin which is closest.
    for (int i = 0; i < numPlatforms_; i++) {

        if (((allPlatforms[i]->y - y) < closestY) && ((allPlatforms[i]->y - y) >  -1)) {
            closestY = allPlatforms[i]->y-y;
            closestPlatform = *allPlatforms[i];
        }
    }
    return closestPlatform;
}

//@Override of base class function
//had to override and rewrite since N5110 is written to write horizontal this needs vertical
// this function reads existing font5x7 and rotate matrix to become font7x5 matrix.
//
// for example the number 4 font5x7 = 0x18,0x14,0x12,0x7F,0x10
//                          font7x5 = 0x02,0x06,0x10,0x12,0x1E,0x2,0x2
//then it is printed!
void GameScreen::printString(const char * str,int x,int y,bool invert)
{
    //set all pixels in rows to black
    if (invert) {
        for (int a = 0; a < 48; a ++) {
            for (int b = y; b < (y+9); b++) {
                setPixel(b,a);
            }
        }
    }

    //scan through string, rotating font5x7 array and printing charector.
    while (*str) {

        //each byte in row
        for (int i = 0; i < 5; i++) {
            //each bit in byte
            for (int b = 0; b < 7; b++) {
                if (invert)
                    setPixel(y+b+1,x-i+1);

                if (font5x7[(*str - 32)*5 + i] & (1<<b)) { //bitwise comparison to mask at desired pixel
                    setPixel(y+b+1,x-i+1);
                    if (invert)
                        clearPixel(y+b+1,x-i+1);
                } else {
                    if (!invert)
                        clearPixel(y+b+1,x-i+1);
                }
            }
        }
        str ++; //next char in string
        x -= 6;
    }
}

void GameScreen::displayStartScreen()
{
    clear();
    printString("LET",maxX_ - 14,-1);
    printString("THE BALL",maxX_ - 2,7);
    printString("DROP!",maxX_ - 12,16);
    printString("This way",maxX_ - 2,30);
    printString("------->",maxX_ - 2,37);
    printString("TO PLAY!",maxX_ - 2,45);
    printString("by: ",maxX_ - 2,61);
    printString("Thomas",maxX_ - 9,69);
    printString("Davies",maxX_ - 9,76);
    refresh();
}

void GameScreen::displayInstructionScreen()
{
    clear();
    printString("Hi Ball,",maxX_ - 2,-1);
    printString("You are",maxX_ - 2,7);
    printString("TRAPPED!",maxX_ - 2,15);
    printString("Hit the",maxX_ - 2,23);
    printString("roof and",maxX_ - 2,32);
    printString("you'll",maxX_ - 2,39);
    printString("surely",maxX_ - 2,47);
    printString("DIE!!",maxX_ - 2,55);
    printString("------->",maxX_ - 2,75);
    refresh();
}

void GameScreen::displayInstructionScreen2()
{
    clear();
    printString("CONTROLS",maxX_ - 2,-1);
    printString("Use the",maxX_ - 2,15);
    printString("joystick",maxX_ - 2,23);
    printString("to move",maxX_ - 2,32);
    printString("left or",maxX_ - 2,39);
    printString("right.",maxX_ - 2,47);
    printString("Click to",maxX_ - 2,55);
    printString("Pause!",maxX_ - 2,63);
    printString("------->",maxX_ - 2,75);
    refresh();
}

void GameScreen::displayCountdown()
{
    clear();
    Timer countdown;        //timer for countdown
    char buffer[10];
    countdown.start();
    printString("Survive!",maxX_ - 2,10);
    refresh();

    int prevTime = -1;
    //countdown from 5 to 1, in seconds.
    while (countdown.read() < 5) {
        if (floor(countdown.read()) > prevTime) {
            sprintf(buffer,"..%1.0f..",(5 - floor(countdown.read())));
            printString(buffer,maxX_ - 10,20 + 10*countdown.read());
            refresh();
            prevTime = countdown.read();
        }
    }
    countdown.stop();
}

void GameScreen::displayEndScreen(int lvl,int *cursor, bool isRecord)
{
    clear();
    char buffer [10];
    sprintf(buffer,"lvl: %d",lvl);
    printString("GameOver",maxX_ - 2,-1);
    printString("   :(  ",maxX_ - 2,7);
    printString(buffer,maxX_ - 2,23);
    printString("Reached!",maxX_ - 2,32);

    //only display record option if player achieved record!
    if (isRecord)
        printString("Record",maxX_ - 8,55,cursor[0]);

    printString("View",maxX_ - 15,63,cursor[1]);
    printString("Restart",maxX_ - 5,71,cursor[2]);
    refresh();
}

void GameScreen::displayRecordScreen(int *cursor,char ltr1,char ltr2,char ltr3)
{
    clear();
    printString("Enter",maxX_ - 2,-1);
    printString("Initials",maxX_ - 2,7);

    //letter entry
    char buffer[2];
    sprintf(buffer,"%c",ltr1);
    printString(buffer,maxX_ - 23,20,cursor[0]);
    sprintf(buffer,"%c",ltr2);
    printString(buffer,maxX_ - 23,32,cursor[1]);
    sprintf(buffer,"%c",ltr3);
    printString(buffer,maxX_ - 23,44,cursor[2]);

    printString("Click",maxX_ - 2,59);
    printString("when",maxX_ - 2,67);
    printString("finished",maxX_ - 2,75);
    refresh();

}

void GameScreen::displayHighScores(char *s_hs0,char *s_hs1,char *s_hs2,int *d_hs)
{
    clear();
    printString("SCORES",maxX_ - 2,-1);

    char buffer[10];

    sprintf(buffer,"%s %d",s_hs0,d_hs[0]);
    printString(buffer,maxX_ - 2,15);

    sprintf(buffer,"%s %d",s_hs1,d_hs[1]);
    printString(buffer,maxX_ - 2,33);

    sprintf(buffer,"%s %d",s_hs2,d_hs[2]);
    printString(buffer,maxX_ - 2,51);

    printString("Click to",maxX_ - 2,68);
    printString("reset!",maxX_ - 2,76);
    refresh();
}

void GameScreen::displayPauseScreen(int *cursor,char isSound)
{
    clear();
    printString("PAUSED",maxX_ - 2,7);

    char buffer[10];
    sprintf(buffer,"Sound? %c",isSound);
    printString(buffer,maxX_ - 2,30,cursor[0]);
    printString("Restart",maxX_ - 2,45,cursor[1]);
    printString("Return",maxX_ - 2,61,cursor[2]);
    refresh();
}

