#include "mbed.h"

#include "MuNFC.h"

DigitalOut led_alive(LED1);
DigitalOut led_progress(LED2);
DigitalOut led_ok(LED3);
DigitalOut led_failed(LED4);

PwmOut red(p26);
PwmOut green(p24);
PwmOut blue(p25);

MuNFC nfc("00000001aZSe2vF5", 1, p11, p12, p13, p19, p18);

#define DEFAULT_PACKET 1

uint8_t r;
uint8_t g;
uint8_t b;

//Encode callback
void encode_cb(TLVList* tlv, void *)
{
  tlv->putUInt8( DEFAULT_PACKET); //First uint8_t is packet type
  tlv->putUInt8(r);
  tlv->putUInt8(g);
  tlv->putUInt8(b);
}

//Decode callback
void decode_cb(TLVList* tlv, void *)
{
  if(tlv->getNext() != UINT8)
  {
    return;
  }
  if(tlv->getUInt8() == DEFAULT_PACKET) //First uint8_t is packet type
  { 
    if(tlv->getNext() != UINT8)
    {
      return;
    }
    r=tlv->getUInt8();
    if(tlv->getNext() != UINT8)
    {
      return;
    }
    g=tlv->getUInt8();
    if(tlv->getNext() != UINT8)
    {
      return;
    }
    b=tlv->getUInt8();
  }
     /////////////////////////
     //SET RGB LEDS PWM HERE//
     /////////////////////////
     red = pow((float)r, 2.0f) / (255.0*255.0);
     green = pow((float)g, 2.0f) / (255.0*255.0);
     blue = pow((float)b, 2.0f) / (255.0*255.0);

}

//NFC event
void event_cb(NFCEvent event, void*)
{
    switch(event)
    {
    case NFC_TRANSACTION_STARTED:
        led_progress=1;
        led_ok=0;
        led_failed=0;
    break;
    case NFC_TRANSACTION_SUCCESSFUL:
        led_progress=0;
        led_ok=1;
        led_failed=0;
    break;
    case NFC_TRANSACTION_FAILED:
        led_progress=0;
        led_ok=0;
        led_failed=1;
    break;    
    }
}

int main() {
    r=g=b=0;
    
    nfc.encode(encode_cb, NULL);
    nfc.decode(decode_cb, NULL);
    nfc.event(event_cb, NULL);
    
    printf("Hello");
    
    bool ret = nfc.init();
    if(ret)
    {
      printf("AppNearMe/MuNFC stack initialized\n");
      
    }
    else
    {
      printf("Could not initialize stack\n");
    }
    
    nfc.run();
    
    while(1) {
        led_alive = 1;
        wait(0.2);
        led_alive = 0;
        wait(0.2);
    }
}
