#include "mbed.h"
#include "rtos/rtos.h"

#include "MuNFC.h"

DigitalOut led_alive(LED1);
DigitalOut led_progress(LED2);
DigitalOut led_ok(LED3);
DigitalOut led_failed(LED4);
Semaphore s(1);

MuNFC nfc("00000003RdfgT390", 1, p11, p12, p13, p19, p18);

#define DEFAULT_PACKET 1

char inputText[24];


//Encode callback
void encode_cb(TLVList* tlv, void *)
{
  static uint32_t counter = 0;
  counter++;
  tlv->putUInt8( DEFAULT_PACKET ); //First uint8_t is packet type
  tlv->putString("Hello from mbed!");
  tlv->putUInt32( counter );
}

//Decode callback
void decode_cb(TLVList* tlv, void *)
{
  if(tlv->getNext() != UINT8)
  {
    return;
  }
  if(tlv->getUInt8() == DEFAULT_PACKET) //First uint8_t is packet type
  { 
    if(tlv->getNext() != STRING)
    {
      return;
    }
    tlv->getString(inputText, 23);
  }
  s.release();
}

//NFC event
void event_cb(NFCEvent event, void*)
{
    switch(event)
    {
    case NFC_TRANSACTION_STARTED:
        led_progress=1;
        led_ok=0;
        led_failed=0;
    break;
    case NFC_TRANSACTION_SUCCESSFUL:
        led_progress=0;
        led_ok=1;
        led_failed=0;
    break;
    case NFC_TRANSACTION_FAILED:
        led_progress=0;
        led_ok=0;
        led_failed=1;
    break;    
    }
}

int main() {   
    nfc.encode(encode_cb, NULL);
    nfc.decode(decode_cb, NULL);
    nfc.event(event_cb, NULL);
    s.wait();
    
    bool ret = nfc.init();
    if(ret)
    {
      printf("\nAppNearMe/MuNFC stack initialized\n");
      
    }
    else
    {
      printf("Could not initialize stack\n");
    }
    
    nfc.run(); //Start thread
    
    while(1) {
        led_alive = !led_alive;
        if(s.wait(200) > 0)
        {
          printf("Got: %s\n",inputText);
        }
    }
}
