/*
    rtos.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef RTOS_H_
#define RTOS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

struct rtos_semaphore; //To be defined by impl
typedef struct rtos_semaphore rtos_semaphore_t;

rtos_semaphore_t* rtos_semaphore_new(void); //Should return NULL if fails

int rtos_semaphore_produce(rtos_semaphore_t* pSem);
int rtos_semaphore_consume(rtos_semaphore_t* pSem, int timeout);

#ifdef __cplusplus
}
#endif

#endif /* RTOS_H_ */
