/*
    pn532_status.h 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#ifndef PN532_STATUS_H_
#define PN532_STATUS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/errors.h"

#define PN532_STATUS_TIMEOUT           0x01 //Time Out, the target has not answered
#define PN532_STATUS_CRC               0x02 //A CRC error has been detected by the CIU
#define PN532_STATUS_PARITY            0x03 //A Parity error has been detected by the CIU 0x03
#define PN532_STATUS_BITCOUNT          0x04 //During an anti-collision/select operation (ISO/IEC14443-3
                                         //Type A and ISO/IEC18092 106 kbps passive mode), an
                                         //erroneous Bit Count has been detected
#define PN532_STATUS_FRAMING           0x05 //Framing error during Mifare operation
#define PN532_STATUS_ANTICOLL          0x06 //An abnormal bit-collision has been detected during bit wise
                                         //anti-collision at 106 kbps
#define PN532_STATUS_BUFFER_TOO_SMALL  0x07 //Communication buffer size insufficient 0x07
#define PN532_STATUS_BUFFER_OVERFLOW   0x09 //RF Buffer overflow has been detected by the CIU (bit
                                         //BufferOvfl of the register CIU_Error)
#define PN532_STATUS_NFCIP1_ACTIVE     0x0A //In active communication mode, the RF field has not been
                                         //switched on in time by the counterpart (as defined in NFCIP-1
                                         //standard)
#define PN532_STATUS_RF                0x0B //RF Protocol error
#define PN532_STATUS_OVERHEAT          0x0D //Temperature error: the internal temperature sensor has
                                         //detected overheating, and therefore has automatically
                                         //switched off the antenna drivers
#define PN532_STATUS_INTERNAL          0x0E //Internal buffer overflow
#define PN532_STATUS_INVALID_PARAM     0x10 //Invalid parameter (range, format, )
#define PN532_STATUS_RELEASED          0x29 //Target has been released (RF off)

#define ___PN532_STATUS_CHECK(e,s) ((e&0x3F)==s)
#define PN532_STATUS_TO_ERR( e ) (___PN532_STATUS_CHECK((e&0x3F),0)?OK: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_TIMEOUT))?ERR_TIMEOUT:  \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_CRC))?ERR_CRC: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_PARITY))?ERR_PARITY: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_BITCOUNT))?ERR_PROTOCOL: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_FRAMING))?ERR_PROTOCOL: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_NFCIP1_ACTIVE))?ERR_PROTOCOL: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_RF))?ERR_PROTOCOL: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_ANTICOLL))?ERR_COLLISION: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_BUFFER_TOO_SMALL))?ERR_BUFFER_TOO_SMALL: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_BUFFER_OVERFLOW))?ERR_CONTROLLER: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_OVERHEAT))?ERR_CONTROLLER: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_INTERNAL))?ERR_CONTROLLER: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_INVALID_PARAM))?ERR_PARAMS: \
                                (___PN532_STATUS_CHECK(e,PN532_STATUS_RELEASED))?ERR_FIELD: \
                                ERR_UNKNOWN \
                              )

#ifdef __cplusplus
}
#endif

#endif /* PN532_STATUS_H_ */
