/*
    NdefCallback.h 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#ifndef NDEFCALLBACK_H_
#define NDEFCALLBACK_H_

#include "TLVList.h"

#include "munfc/core/fwk.h"
#include "munfc/ndef/appnearme_ndef.h"

class NdefCallback
{
protected:
  NdefCallback(); //Callable by MuNFC

  void init(void (*fn)(appnearme_ndef_callback, void*));

  void attach(void (*fn)(TLVList*, void*), void* arg);

  template <class T>
  void attach(T* inst, void (T::*member)(TLVList*))
  {
    m_fn = NULL;
    m_inst = inst;
    memcpy(m_pMember, (char*)&member, sizeof(member));
    m_caller = &NdefCallback::memberCaller<T>;
  }

private:
  void callback(tlv_list* payload);

  //Data
  TLVList m_tlvList;

  //Function
  void(*m_fn)(TLVList*, void*);
  void* m_arg;

  //Member of object instance
  void* m_inst;
  char m_pMember[16];
  void (*m_caller)(NdefCallback*, TLVList*);

  template <class T>
  static inline void memberCaller(NdefCallback* p, TLVList* tlvList)
  {
    T* inst = (T*) (p->m_inst);
    void (T::*member)(TLVList*);
    memcpy(&member, p->m_pMember, sizeof(member));
    (inst->*member)(tlvList);
  }

  static void staticCallback(tlv_list* payload, void* param);

  friend class MuNFC;
};


#endif /* NDEFCALLBACK_H_ */
