/*
    pn512_platform.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/


#ifndef PN512_PLATFORM_H_
#define PN512_PLATFORM_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

#include "drv/pn512/pn512.h"

/*
 * Initialize SPI
 */
int pn512_spi_init(void);

/*
 * Init
 */
void pn512_io_init(void);

/*
 * Get the IRQ pin's state
 */
bool pn512_irq_pin_get(void);

/*
 * Set the CS pin to 0 (active low)
 */
void pn512_cs_set(void);

/*
 * Set the CS pin to 1 (active high)
 */
void pn512_cs_clear(void);

/*
 * You MUST call pn512_irq() on each raising front of IRQ pin
 */

#ifdef __cplusplus
}
#endif

#endif /* PN512_PLATFORM_H_ */
