/*
    appnearme_ndef_util.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef APPNEARME_NDEF_UTIL_H_
#define APPNEARME_NDEF_UTIL_H_

#include "core/fwk.h"

//MSB first
#define WRITE_UINT32_NDEF( addr, val ) do{ *(((uint8_t*)(addr)) + 0) = (val >> 24 ) & 0xFF; \
                                           *(((uint8_t*)(addr)) + 1) = (val >> 16 ) & 0xFF; \
                                           *(((uint8_t*)(addr)) + 2) = (val >> 8 ) & 0xFF; \
                                           *(((uint8_t*)(addr)) + 3) = (val >> 0 ) & 0xFF; } while(0)
#define WRITE_UINT16_NDEF( addr, val ) do{ *(((uint8_t*)(addr)) + 0) = (val >> 8 ) & 0xFF; \
                                           *(((uint8_t*)(addr)) + 1) = (val >> 0 ) & 0xFF; } while(0)

//MSB first
#define READ_UINT32_NDEF( addr, val ) do{ val = (*(((uint8_t*)(addr)) + 0) << 24 ) \
                                              | (*(((uint8_t*)(addr)) + 1) << 16 ) \
                                              | (*(((uint8_t*)(addr)) + 2) << 8 ) \
                                              | (*(((uint8_t*)(addr)) + 3) << 0 ); } while(0)
#define READ_UINT16_NDEF( addr, val ) do{ val = (*(((uint8_t*)(addr)) + 0) << 8 ) \
                                              | (*(((uint8_t*)(addr)) + 1) << 0 ); } while(0)

#endif /* APPNEARME_NDEF_UTIL_H_ */
