/*
    transaction_event.h
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#ifndef TRANSACTION_EVENT_H_
#define TRANSACTION_EVENT_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

typedef enum __transaction_event
{
  TRANSACTION_STARTED, //< Transaction with reader/tag started (anticollision successful)
  TRANSACTION_SUCCESSFUL, //< Transaction with reader/tag successful
  TRANSACTION_FAILED //< Transaction with reader/tag failed
} transaction_event;

typedef enum __transaction_type
{
  TRANSACTION_READER, //< Transaction in reader mode (with a tag)
  TRANSACTION_TARGET, //< Transaction in target mode (with a reader)
} transaction_type;

typedef void (*transaction_event_callback)(transaction_event event, transaction_type type, void* param);

void transaction_event_init(void);

void transaction_event_register_callback(transaction_event_callback cb, void* param);

void transaction_event_fire(transaction_event event, transaction_type type);

#ifdef __cplusplus
}
#endif

#endif /* TRANSACTION_EVENT_H_ */
