/*
    debug.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef DEBUG_H_
#define DEBUG_H_

#include "core/fwk.h"

#ifdef __cplusplus
extern "C" {
#endif

#if !DEBUG_DISABLED

void debug(int level, const char* module, int line, const char* fmt, ...);
void debugx_enter(void);
void debugx(const char* fmt, ...);
void debugx_leave(void);

#else
#ifdef __DEBUG__
#undef __DEBUG__
#define __DEBUG__ 0
#endif

#endif

#if __DEBUG__ > 0
#ifndef __MODULE__
#error "__MODULE__ must be defined"
#endif
#endif

#if __DEBUG__ >= 1
#define ERR(...) do{ debug(1, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#else
#define ERR(...)
#endif

#if __DEBUG__ >= 2
#define WARN(...) do{ debug(2, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#else
#define WARN(...)
#endif

#if __DEBUG__ >= 3
#define DBG(...) do{ debug(3, __MODULE__, __LINE__, __VA_ARGS__); }while(0)
#define DBGX_ENTER() do{ debugx_enter(); }while(0);
#define DBGX(...) do{ debugx(__VA_ARGS__); }while(0)
#define DBGX_LEAVE() do{ debugx_leave(); }while(0);
#else
#define DBG(...)
#define DBGX_ENTER()
#define DBGX(...)
#define DBGX_LEAVE()
#endif

#ifdef __cplusplus
}
#endif

#endif

