/*
  buffer.h
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef BUFFER_H_
#define BUFFER_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

typedef struct __buffer
{
  uint8_t* bufdata;
  size_t size;

  uint8_t* start;
  size_t first_byte_length; //In bits

  uint8_t* end;
  size_t last_byte_length; //In bits

  struct __buffer* next;

} buffer;

void buffer_init(buffer* pBuf, uint8_t* bufdata, size_t size);

void buffer_byref(buffer* pBuf, uint8_t* bufdata, size_t length); //New buffer by ref on a size_t array, no malloc (useful on PIC for instance)

buffer* buffer_new(size_t size); //malloc

uint8_t* buffer_data(buffer* pBuf);

void buffer_reset(buffer* pBuf);

size_t buffer_size(buffer* pBuf);

size_t buffer_length(buffer* pBuf);

bool buffer_empty(buffer* pBuf);

void buffer_set_length(buffer* pBuf, size_t length);

size_t buffer_last_byte_length(buffer* pBuf);

void buffer_set_last_byte_length(buffer* pBuf, size_t length);

size_t buffer_bits_count(buffer* pBuf);

void buffer_write_byte(buffer* pBuf, uint8_t b);

void buffer_write_bit(buffer* pBuf, uint8_t b);

#if 0
size_t buffer_read_byte(buffer* pBuf, uint8_t b);

size_t buffer_read_bit(buffer* pBuf, uint8_t b);
#endif

buffer* buffer_next(buffer* pBuf);

void buffer_set_next(buffer* pBuf, buffer* pNextBuf);

void buffer_append(buffer* pBuf, buffer* pAppBuf);

void buffer_unlink(buffer* pBuf, buffer* pLinkedBuf);

size_t buffer_total_size(buffer* pBuf);

size_t buffer_total_length(buffer* pBuf);

void buffer_set_total_length(buffer* pBuf, size_t length);

void buffer_free(buffer* pBuf);

#ifdef __cplusplus
}
#endif

#endif /* BUFFER_H_ */
