/*
    MuNFC.cpp
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#include "MuNFC.h"
#include "MuNFCConfig.h"

#include "mbed.h"
#if MUNFC_RTOS
#include "rtos/rtos.h"
#endif

#include "munfc/core/fwk.h"
#include "munfc/event/transaction_event.h"
#include "munfc/target/target_nfctype2.h"
#include "munfc/target/target_nfctype4.h"
#include "munfc/ndef/appnearme_ndef.h"
#include "munfc/ndef/appnearme_ndef_tlv.h"

#include <cstring> //For memcpy, strlen

//TODO add handles in NFC stack to avoid ugly things like that
//extern DigitalIn* nfc_irq_pin_int;
extern InterruptIn* nfc_irq_pin_isr;
extern DigitalOut* nfc_cs_pin;
extern SPI* nfc_spi;

#define SIGNAL_START 0x01

MuNFC::MuNFC(char appHash[16], uint32_t version,
    PinName mosi, PinName miso, PinName sclk, PinName cs, PinName isr) :
   /* m_irq_pin_int(isr),*/ m_irq_pin_isr(isr), m_cs_pin(cs), m_spi(mosi, miso, sclk)
#if MUNFC_RTOS
  , m_pThread(NULL)//m_thread(MuNFC::staticCallback, (void*)this)
#endif
{
  //nfc_irq_pin_int = &m_irq_pin_int;
  nfc_irq_pin_isr = &m_irq_pin_isr;
  nfc_cs_pin = &m_cs_pin;
  nfc_spi = &m_spi;

  appnearme_ndef_init(appHash, version);
  m_eventCb.init(transaction_event_register_callback);
  m_encodeCb.init(appnearme_ndef_register_encode_callback);
  m_decodeCb.init(appnearme_ndef_register_decode_callback);
}

MuNFC::~MuNFC()
{
  #if MUNFC_RTOS
  if(m_pThread != NULL)
  {
    delete m_pThread;
  }
  #endif
}

bool MuNFC::init()
{
  #if MUNFC_RTOS
  if(m_pThread == NULL)
  {
    m_pThread = new Thread(MuNFC::staticCallback, (void*)this);
  }
  #endif

#if NFC_CONTROLLER == PN512
  int ret = target_nfctype2_start();
#elif NFC_CONTROLLER == PN532
  int ret = target_nfctype4_start();
#endif
  if(ret != OK)
  {
    return false;
  }
  return true;
}

#if MUNFC_RTOS
void MuNFC::run()
{
  //Start NFC thread
  m_pThread->signal_set(SIGNAL_START);
}

void MuNFC::process()
{
  Thread::signal_wait(SIGNAL_START);
  do
  {
    poll(-1);
  } while(true);
}
#endif

void MuNFC::poll(int timeoutMs) //TODO add Timeout
{
#if NFC_CONTROLLER == PN512
    target_nfctype2_process();
#elif NFC_CONTROLLER == PN532
    target_nfctype4_process();
#endif
}

#if MUNFC_RTOS
  /*static*/ void MuNFC::staticCallback(void const* p)
  {
    ((MuNFC*)p)->process();
  }
#endif
