/*
    EventCallback.h 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#ifndef EVENTCALLBACK_H_
#define EVENTCALLBACK_H_

#include "NFCEvent.h"

#include "munfc/core/fwk.h"
#include "munfc/event/transaction_event.h"

class EventCallback
{
protected:
  EventCallback();

  void init( void (*fn)(transaction_event_callback, void*) ); //Callable by MuNFC

  void attach(void (*fn)(NFCEvent, void*), void* arg);

  template <class T>
  void attach(T* inst, void (T::*member)(NFCEvent))
  {
    m_fn = NULL;
    m_inst = inst;
    memcpy(m_pMember, (char*)&member, sizeof(member));
    m_caller = &EventCallback::memberCaller<T>;
  }


private:
  void callback(transaction_event event, transaction_type type);

  //Function
  void(*m_fn)(NFCEvent, void*);
  void* m_arg;


  //Member of object instance
  void* m_inst;
  char m_pMember[16];
  void (*m_caller)(EventCallback*, NFCEvent);

  template <class T>
  static inline void memberCaller(EventCallback* p, NFCEvent event)
  {
    T* inst = (T*) p->m_inst;
    void (T::*member)(NFCEvent);
    memcpy(&member, p->m_pMember, sizeof(member));
    (inst->*member)(event);
  }

  static void staticCallback(transaction_event event, transaction_type type, void* param);

  friend class MuNFC;
};



#endif /* EVENTCALLBACK_H_ */
