/*
    EventCallback.cpp 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/

#include "EventCallback.h"

EventCallback::EventCallback()
{

}

void EventCallback::init(void (*fn)(transaction_event_callback, void*))
{
  fn(staticCallback, this);
}

void EventCallback::attach(void (*fn)(NFCEvent, void*), void* arg)
{
  m_inst = NULL;
  m_fn = fn;
  m_arg = arg;
}

void EventCallback::callback(transaction_event event, transaction_type type)
{
  if(m_inst)
  {
    m_caller(this, (NFCEvent)event); //At some point, should not cast event directly
  }
  else if(m_fn)
  {
    m_fn((NFCEvent)event, m_arg);
  }
}

/*static*/ void EventCallback::staticCallback(transaction_event event, transaction_type type, void* param)
{
  ((EventCallback*)(param))->callback(event, type);
}





