/*
    spi.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef SPI_H_
#define SPI_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

//These functions must be implemented for each platform

/*
 * After skipping outSkip bytes, write outLen bytes
 * After skipping inSkip bytes, read inLen bytes
 * This will generate MAX(outSkip + outLen, inSkip + inLen) transfers on the SPI bus
 */
int spi_transfer( uint8_t* outBuf, size_t outLen, size_t outSkip, uint8_t* inBuf, size_t inLen, size_t inSkip );

/*
 * Write outLen bytes
 */
int spi_write( uint8_t* outBuf, size_t outLen );

/*
 * Read inLen bytes
 */
int spi_read( uint8_t* inBuf, size_t inLen );

/*
 * Skip len bytes
 */
int spi_skip( size_t len );

#ifdef __cplusplus
}
#endif

#endif /* SPI_H_ */
