/*
    appnearme_ndef_tlv.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef APPNEARME_NDEF_TLV_H_
#define APPNEARME_NDEF_TLV_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "core/buffer.h"

typedef enum __tlv_type
{
  UINT8,
  UINT32,
  UINT8_ARRAY,
  STRING,
  NONE, //End of packet
  UNKNOWN
} tlv_type;

typedef struct __tlv_list
{
  buffer* buf;
  size_t pos;
  //bool writer_nreader;
} tlv_list;

void appnearme_ndef_tlv_byref(tlv_list* pList, buffer* pBuf/*, bool writer_nreader*/);

tlv_type appnearme_ndef_tlv_next_type(tlv_list* pList);

uint8_t appnearme_ndef_tlv_get_uint8(tlv_list* pList);

uint32_t appnearme_ndef_tlv_get_uint32(tlv_list* pList);

size_t appnearme_ndef_tlv_get_array_length(tlv_list* pList);

uint8_t* appnearme_ndef_tlv_get_array(tlv_list* pList);

size_t appnearme_ndef_tlv_get_string_length(tlv_list* pList);

char* appnearme_ndef_tlv_get_string(tlv_list* pList);

int appnearme_ndef_tlv_put_uint8(tlv_list* pList, uint8_t b); //-1 if no space left

int appnearme_ndef_tlv_put_uint32(tlv_list* pList, uint32_t b);

int appnearme_ndef_tlv_put_array(tlv_list* pList, uint8_t* data, size_t len);

int appnearme_ndef_tlv_put_string(tlv_list* pList, char* str);

#ifdef __cplusplus
}
#endif

#endif /* APPNEARME_NDEF_TLV_H_ */
