/*
  pn512_irq.h
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef PN512_IRQ_H_
#define PN512_IRQ_H_

#ifdef __cplusplus
extern "C" {
#endif

#define PN512_IRQ_TX          (1<<6)
#define PN512_IRQ_RX          (1<<5)
#define PN512_IRQ_IDLE        (1<<4)
#define PN512_IRQ_HIGH_ALERT  (1<<3)
#define PN512_IRQ_LOW_ALERT   (1<<2)
#define PN512_IRQ_ERR         (1<<1)
#define PN512_IRQ_TIMER       (1<<0)

#define PN512_IRQ_SIGIN       (1<<(4+8))
#define PN512_IRQ_MODE        (1<<(3+8))
#define PN512_IRQ_CRC         (1<<(2+8))
#define PN512_IRQ_RF_ON       (1<<(1+8))
#define PN512_IRQ_RF_OFF      (1<<(0+8))

#define PN512_IRQ_NONE        0

#define PN512_REG_COMIEN_MASK 0x7F
#define PN512_REG_COMIEN_VAL  0x00

#define PN512_REG_DIVIEN_MASK 0x1F
#define PN512_REG_DIVIEN_VAL  0x80

#define PN512_REG_COMIRQ_MASK 0x7F
#define PN512_REG_COMIRQ_CLEAR  0x00

#define PN512_REG_DIVIRQ_MASK 0x1F
#define PN512_REG_DIVIRQ_CLEAR  0x00

void pn512_irq_init(void);

void pn512_irq_set(uint16_t irqs); //ORed
uint16_t pn512_irq_get(void); //ORed

int pn512_irq_wait(int timeout);

void pn512_irq_clear(void);

bool pn512_irq_state(void);

#ifdef __cplusplus
}
#endif

#endif /* PN512_IRQ_H_ */
