/*
  pn512_cmd.h
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef PN512_CMD_H_
#define PN512_CMD_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

#define PN512_CMD_IDLE        0x00 //No action, cancels current command execution
#define PN512_CMD_MEM         0x01 //Stores 25 bytes into the internal buffer
#define PN512_CMD_CONFIG      0x01 //Configures the PN512 for FeliCa, MIFARE and NFCIP-1 communication
#define PN512_CMD_RNDIDG      0x02 //Generates a 10-byte random ID number
#define PN512_CMD_CRC         0x03 //Activates the CRC coprocessor or performs a self test
#define PN512_CMD_TRANSMIT    0x04 //Transmits data from the FIFO buffer
#define PN512_CMD_NOCHANGE    0x07 //No command change
#define PN512_CMD_RECEIVE     0x08 //Activates the receiver circuits
#define PN512_CMD_TRANSCEIVE  0x0C //Transmits data from FIFO buffer to antenna and automatically activates the receiver after transmission
#define PN512_CMD_AUTOCOLL    0x0D //Handles FeliCa polling (Card Operation mode only) and MIFARE anticollision (Card Operation mode only)
#define PN512_CMD_MFAUTH      0x0E //Performs the MIFARE standard authentication as a reader
#define PN512_CMD_SOFTRST     0x0F //Resets the PN512

#define PN512_CMD_REG_MASK    0x0F

void pn512_cmd_init(void);

//Fifo read / write
size_t pn512_fifo_write(uint8_t* buf, size_t len);
size_t pn512_fifo_read(uint8_t* buf, size_t len);

//Fifo clear
void pn512_fifo_clear(void);

//Fifo bytes read
size_t pn512_fifo_space(void);
size_t pn512_fifo_length(void);

//Execute command
void pn512_cmd_exec(uint8_t cmd);

//Read executed command
uint8_t pn512_cmd_get(void);

//Sets xmit last byte bits
void pn512_tx_set_last_byte_size(size_t bits);

//Gets rcv last byte bits
size_t pn512_rx_get_last_byte_size(void);

#define PN512_TRANSCEIVE_TX 1
#define PN512_TRANSCEIVE_RX 2
//Start transceive
int pn512_transceive(int option);

int pn512_target_anticollision(void);

#ifdef __cplusplus
}
#endif

#endif /* PN512_CMD_H_ */
