/*
    fwk.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/


#ifndef FWK_H_
#define FWK_H_

#include "nfc_config.h"

//Standard types definition
#include "stdint.h"

#include "stddef.h"

//Definition of size_t on 32-bit arch
#if !defined (__SIZE_TYPE__)
typedef uint32_t size_t;
#endif

#ifndef __cplusplus
typedef uint8_t bool; //Define boolean type for pure-C functions
#define true 1
#define false 0
#endif

//NULL pointer definition
#ifndef NULL
#define NULL ((void*)0)
#endif

//Error codes
#include "errors.h"

//RTOS abstraction
#include "platform/platform_rtos.h"

//Debugging
#include "debug.h"

//Buffer
#include "buffer.h"

//Macros
#define MAX(a,b) (((a)>(b))?(a):(b))
#define MIN(a,b) (((a)<(b))?(a):(b))

#endif /* FWK_H_ */
