/*
    pn532_platform.h
    Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/


#ifndef PN532_PLATFORM_H_
#define PN532_PLATFORM_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

#include "drv/pn532/pn532.h"

/*
 * Initialize SPI
 */
int pn532_spi_init(void);

/*
 * Init
 */
void pn532_io_init(void);

/*
 * Get the IRQ pin's state
 */
bool pn532_irq_pin_get(void);

/*
 * Set the CS pin to 0 (active low)
 */
void pn532_cs_set(void);

/*
 * Set the CS pin to 1 (active high)
 */
void pn532_cs_clear(void);

/*
 * You MUST call pn532_irq() on each falling front of IRQ pin
 */

#ifdef __cplusplus
}
#endif

#endif /* PN532_PLATFORM_H_ */
