/*
    appnearme_ndef.h 
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/


#ifndef APPNEARME_NDEF_H_
#define APPNEARME_NDEF_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "core/buffer.h"

#include "appnearme_ndef_tlv.h"

#define APPNEARME_HASH_SIZE 16

typedef void (*appnearme_ndef_callback)(tlv_list* payload, void* param);

int appnearme_ndef_init(char app_hash[APPNEARME_HASH_SIZE], uint32_t version);

void appnearme_ndef_register_encode_callback(appnearme_ndef_callback cb, void* param);

void appnearme_ndef_register_decode_callback(appnearme_ndef_callback cb, void* param);

int appnearme_ndef_encode_message(buffer* pMem);

int appnearme_ndef_decode_message(buffer* pMem);

#ifdef __cplusplus
}
#endif

#endif /* APPNEARME_NDEF_H_ */
