/*
  transceiver.h
  Copyright (c) Donatien Garnier 2012
  donatien.garnier@appnearme.com
  http://www.appnearme.com/
*/

#ifndef TRANSCEIVER_H_
#define TRANSCEIVER_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"
#include "core/buffer.h"
#include "protocols.h"

//Must be implemented

int transceiver_init(void);
int transceiver_set_protocol(RF_PROTOCOL protocol);

int transceiver_transceive(RF_PROTOCOL protocol, buffer* pDataOutBuf, buffer* pDataInBuf, RF_OPTION options /*= RF_OPTION_NONE*/);

int transceiver_set_RF_field(bool on);

int transceiver_target_anticollision(buffer* pUID, /*TODO: buffer* pParams [SAK/etc], */ int timeout);

int transceiver_target_halt(void);

int transceiver_reader_anticollision(buffer* pUID, buffer* pParams, int timeout);

int transceiver_free(void);

#ifdef __cplusplus
}
#endif

#endif /* TRANSCEIVER_H_ */
