/*
    pn532_registers.h 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#ifndef PN532_REGISTERS_H_
#define PN532_REGISTERS_H_


#ifdef __cplusplus
extern "C" {
#endif

//We only place common SFR-accessible registers here for now
#define PN532_REG_CLU_STATUS2 0x6338 //Contains status flags of the receiver, transmitter and Data Mode Detector
#define PN532_REG_CLU_CONTROL 0x633C//0xFFED //Contains miscellaneous Control Registers
#define PN532_REG_CLU_BITFRAMING 0x633D//0xFFEE //Adjustments for bit oriented frames
#define PN532_REG_CLU_MANUALRCV 0x630D //Tuning of the internal receiver
#define PN532_REG_CLU_TXMODE 0x6302 //Defines the transmission data rate and framing during transmission
#define PN532_REG_CLU_RXMODE 0x6303 //Defines the reception data rate and framing during receiving
#define PN532_REG_CLU_TXAUTO 0x6305 //Controls the setting of the antenna driver
#define PN532_REG_CLU_MODE 0x6301 //Defines general modes for transmitting and receiving.
#define PN532_REG_CLU_MIFNFC 0x630C //Defines ISO/IEC 14443A/MIFARE/NFC specific settings in target or card operating mode.

#ifdef __cplusplus
}
#endif


#endif /* PN532_REGISTERS_H_ */
