/*
    pn532_cmd.h 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/


#ifndef PN532_CMD_H_
#define PN532_CMD_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "core/fwk.h"

// Commands
int pn532_cmd_get_firmware_version( uint8_t* pIc, uint16_t* pVersion, int timeout );

#define PN532_PARAMETERS_NONE             0x00
#define PN532_PARAMETERS_NAD_USED         0x01
#define PN532_PARAMETERS_DID_USED         0x02
#define PN532_PARAMETERS_AUTO_ATR_RES     0x04
#define PN532_PARAMETERS_AUTO_RATS        0x10
#define PN532_PARAMETERS_ISO_14443_4_EMU  0x20
#define PN532_PARAMETERS_NO_PRE_POSTAMBLE 0x40

int pn532_cmd_set_parameters( uint8_t flags, int timeout );

int pn532_cmd_sam_configuration( uint8_t mode, int timeout );

//Target mode selection
#define PN532_TARGET_PASSIVE_ONLY  0x01
#define PN532_TARGET_DEP_ONLY      0x02
#define PN532_TARGET_PICC_ONLY     0x04

//Target mode
#define PN532_TARGET_BAUDRATE_MASK    0x70
#define PN532_TARGET_BAUDRATE_106K    0x00
#define PN532_TARGET_BAUDRATE_212K    0x01
#define PN532_TARGET_BAUDRATE_414K    0x02
#define PN532_TARGET_ISO_14443_4_PICC 0x08
#define PN532_TARGET_DEP              0x04
#define PN532_TARGET_FRAMING_MASK     0x03
#define PN532_TARGET_FRAMING_MIFARE   0x00
#define PN532_TARGET_FRAMING_ACTIVE   0x01
#define PN532_TARGET_FRAMING_FELICA   0x02

//Initiator mode
#define PN532_READER_MODE_ISO14443A_106K    0x00
#define PN532_READER_MODE_FELICA_212K       0x01
#define PN532_READER_MODE_FELICA_424K       0x02
#define PN532_READER_MODE_ISO14443B_106K    0x03
#define PN532_READER_MODE_JEWEL_106K        0x04

// pMifareParams : 6 bytes long, pFelicaParams : 18, pNfcId3 : 10
int pn532_cmd_target_init( uint8_t outMode, buffer* pMifareParams, buffer* pFelicaParams,
    buffer* pNfcId3, buffer* pAtrG, buffer* pAtrT, uint8_t* pInMode, buffer* pData, int timeout);

int pn532_cmd_target_get( buffer* pData, uint8_t* pStatus, int timeout );

int pn532_cmd_target_respond( buffer* pData, uint8_t* pStatus, int timeout );

//PN532 handles framing
int pn532_cmd_target_data_get( buffer* pData, uint8_t* pStatus, int timeout );

int pn532_cmd_target_data_respond( buffer* pData, uint8_t* pStatus, int timeout );

int pn532_cmd_target_status( uint8_t* pState, uint8_t* pBaudrate, int timeout );

int pn532_cmd_reader_poll( uint8_t mode, uint8_t* pTargetDetected, buffer* pInitiatorData, int timeout );

//PN532 handles framing
int pn532_cmd_reader_data_transceive( buffer* pDataOut, buffer* pDataIn, uint8_t* pStatus, int timeout );

int pn532_cmd_register_read( uint16_t address, uint8_t* pData, int timeout );

int pn532_cmd_register_write( uint16_t address, uint8_t data, int timeout );

int pn532_cmd_set_rf_field( bool on, int timeout );

int pn532_cmd_set_rf_iso14443a_params( buffer* pData, int timeout );

int pn532_cmd_get_status( uint8_t* pErr, uint8_t* pField, int timeout );

// Low-level command
int pn532_cmd_exec( buffer* pDataOut, buffer* pDataIn, int timeout );

#ifdef __cplusplus
}
#endif

#endif /* PN532_CMD_H_ */
