/*
    NdefCallback.cpp 
    Copyright (c) Donatien Garnier 2012
    donatien.garnier@appnearme.com
    http://www.appnearme.com/
*/

#include "NdefCallback.h"
#include "TLVList.h"

NdefCallback::NdefCallback()
{

}

void NdefCallback::init(void (*fn)(appnearme_ndef_callback, void*))
{
  fn(staticCallback, this);
}

void NdefCallback::attach(void (*fn)(TLVList*, void*), void* arg)
{
  m_inst = NULL;
  m_fn = fn;
  m_arg = arg;
}

void NdefCallback::callback(tlv_list* payload)
{
  m_tlvList.wrap(payload);
  if(m_inst)
  {
    m_caller(this, &m_tlvList);
  }
  else if(m_fn)
  {
    m_fn(&m_tlvList, m_arg);
  }
}

/*static*/ void NdefCallback::staticCallback(tlv_list* payload, void* param)
{
  ((NdefCallback*)(param))->callback(payload);
}


