#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

#define maxSpeed 1


//              main=2^0  LS    ENC2^11
BusOut boardPow(p30,      P1_6, P1_7);

// ls5 nur beim Betrl15
// AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14

AnalogInHL ls1(p18), ls2(p16), ls3(p20), ls4(p19), ls5(p17); // B15

int main(void)
{
    int direction = 0;
    double speed = 1;
    leds = 9;
    boardPow = 3;
    while(1) {
        if(ls1.Read()>500)
        {
            mR.SetPow(speed * 0.8);
            mL.SetPow(0);
            direction = -1;
        }
        else if(ls2.Read()>500)
        {
            mR.SetPow(speed * 1);
            mL.SetPow(speed * 0.5);
            direction = -1;
        }
        else if(ls3.Read()>500)
        {
            mR.SetPow(speed * 1);
            mL.SetPow(speed * 1);
            direction = 0;
        }
        else if(ls4.Read()>500)
        {
            mR.SetPow(speed * 0.5);
            mL.SetPow(speed * 1);
            direction = 1;
        }
        else if(ls5.Read()>500)
        {
            mR.SetPow(0);
            mL.SetPow(speed * 0.8);
            direction = 1;
        }
        else
        {
            speed = maxSpeed;
            while(ls3.Read()<500)
            {
                mL.SetPow(speed*0.4);
                mR.SetPow(speed*-0.4);
            }
            speed = 0.4;
        }
        speed+=0.00001;
        if(speed>maxSpeed)
            speed = maxSpeed;
    }
    return 1;
}
