#include "mbed.h"
#include "main.h"
#include "sx1272-hal.h"
#include "debug.h"

/* Set this flag to '1' to display debug messages on the console */
#define DEBUG_MESSAGE   1


#define RF_FREQUENCY                                868000000 // Hz
#define TX_OUTPUT_POWER                             14        // 14 dBm

#define LORA_BANDWIDTH                              2         // [0: 125 kHz,
//  1: 250 kHz,
//  2: 500 kHz,
//  3: Reserved]

#define LORA_SPREADING_FACTOR                       7         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5,
//  2: 4/6,
//  3: 4/7,
//  4: 4/8]

#define LORA_PREAMBLE_LENGTH                        8
#define LORA_SYMBOL_TIMEOUT                         5         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_FHSS_ENABLED                           false
#define LORA_NB_SYMB_HOP                            4
#define LORA_IQ_INVERSION_ON                        false
#define LORA_CRC_ENABLED                            true

#define BUFFER_SIZE                                 1024      // Define the payload size here

DigitalOut led(LED1);

/*!
 * Radio events function pointer
 */
static RadioEvents_t RadioEvents;

/*
 *  Global variables declarations
 */
SX1272MB2xAS Radio( NULL );

const uint8_t msg[] = "Temp=184.26 \r\nHumi=423.99 \r\n";

uint16_t BufferSize = BUFFER_SIZE;
uint8_t Buffer[BUFFER_SIZE];

int16_t RssiValue = 0.0;
int8_t SnrValue = 0.0;

int msglen = 0;

int main()
{
    uint8_t i;

    debug( "\n\n\r     iGreenhouse Application - Transmitter\n\n\r" );

    // Initialize Radio driver
    RadioEvents.TxDone = OnTxDone;
    RadioEvents.TxTimeout = OnTxTimeout;
    Radio.Init( &RadioEvents );

    // verify the connection with the board
    while( Radio.Read( REG_VERSION ) == 0x00  ) {
        debug( "Radio could not be detected!\n\r", NULL );
        wait( 1 );
    }

    debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1272MB2XAS ) ) , "\n\r > Board Type: SX1272MB2xAS < \n\r" );

    Radio.SetChannel( RF_FREQUENCY );


    debug_if( LORA_FHSS_ENABLED, "\n\n\r             > LORA FHSS Mode < \n\n\r");
    debug_if( !LORA_FHSS_ENABLED, "\n\n\r             > LORA Mode < \n\n\r");

    Radio.SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                       LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                       LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                       LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP,
                       LORA_IQ_INVERSION_ON, 2000000 );

    debug_if( DEBUG_MESSAGE, "Starting sending loop\r\n" );

    led = 0;

    while( 1 ) {
        debug("\r\n========\r\nSending a new Packet\r\n========\r\n");
        strcpy( ( char* )Buffer, ( char* ) msg );
        // We fill the buffer with numbers for the payload
        msglen = strlen((char *) msg);
        for( i = msglen; i < BufferSize; i++ ) {
            Buffer[i] = i - msglen;
        }
        wait_ms( 10 );
        Radio.Send( Buffer, BufferSize );
        
        led = 1-led;
        
        // Wait 3 seconds before resend a message
        wait(3);
    }
}

void OnTxDone( void )
{
    Radio.Sleep( );
    debug_if( DEBUG_MESSAGE, "> OnTxDone\n\r" );
    debug_if( DEBUG_MESSAGE, "Message: %s \r\nLenght: %d \r\n", (char *) Buffer, msglen);
}

void OnTxTimeout( void )
{
    Radio.Sleep( );
    debug_if( DEBUG_MESSAGE, "> OnTxTimeout\n\r" );
}
