#include "mbed.h"
#include "Infrared.h"
#include "SDFileSystem.h"
 
Infrared::Infrared(PinName pin) : irLed(pin) {  // _pin(pin) means pass pin to the DigitalOut constructor
        irLed = 0;                                        // default the output to 0
}   
   
    
void Infrared::header(void)
{

    long float repeat;
    
    repeat = phead/(cycleOn+cycleOff);
    
    repeat *= 0.78; // correction for overhead of loops
    
    /* uses the length of the header pulse over the length of the on/off 
    modulation to give an integer representation of the number of cycles */
    //pc.printf("%x\n", repeat);

    for(int k = 0; k < repeat; k++)
    {
        irLed = 1;   
        wait(cycleOn);
        irLed = 0;   
        wait(cycleOff);
    } // for
           
    wait(shead);

    return;
} //header


/* takes a data input of up to bytes, uses dynamic variables(timings ect),
   calculates pulse lengths, encodes data for pulse modulation,
   and shifts it out LSB first (sharp TV protocol, can be changed) */

void Infrared::strobeSpace(void)
{  // ir cycle time, ones, zeroes, and datastream

    unsigned int temp;
    long float repeat1, repeat0;
    char k;
    
    repeat1 = pone/(cycleOn+cycleOff);
    repeat0 = pzero/(cycleOn+cycleOff);
    /* uses the length of the header pulse over the length of the on/off 
    modulation to give an integer representation of the number of cycles */

    repeat1 *= 0.78; // correction for overhead of loops    
    repeat0 *= 0.78; // correction for overhead of loops
    
    for(char i = 0; i < dataBits; i++)
    {
        temp = data<<i; // shift out lsb first 
        
        
        if(temp & MSB)
        {
            for(k = 0; k < repeat1; k++)
            {
                irLed = 1;   
                wait(cycleOn);
                irLed = 0;   
                wait(cycleOff);
            }// for
            
            wait(sone);
        }// if
    
        else
        {    
            for(k = 0; k < repeat0; k++)
            {
                irLed = 1;   
                wait(cycleOn);
                irLed = 0;   
                wait(cycleOff);
            }// for
            
            wait(szero);
        }// else
        
    }// for
    
    return;
}// strobeSpace


/* takes a data input of up to bytes, uses dynamic variables(timings ect),
   calculates pulse lengths, encodes data for RC6 (manchester) encoding,
   and shifts it out MSB first (philips protocol, can be changed) */

void Infrared::strobeRC6(void)
{  // ir cycle time, ones, zeroes, and datastream

    unsigned long int temp; 
    long float repeat1, repeat0;
    char k;
    
    repeat1 = pone/(cycleOn+cycleOff);
    repeat0 = pzero/(cycleOn+cycleOff);

    repeat1 *= 0.78; // correction for overhead of loops
    repeat0 *= 0.78; // correction for overhead of loops
    
    /* uses the length of the header pulse over the length of the on/off 
    modulation to give an integer representation of the number of cycles */  
      
    for(char i = 0; i < dataBits; i++)
    {
        temp = data<<i; // shift out msb first 
        
        if(temp & MSB)
        {
            //pc.printf("1");
            for(k = 0; k < repeat1; k++)
            {
                irLed = 1;   
                wait(cycleOn);
                irLed = 0;   
                wait(cycleOff);
            }// for
        
            wait(sone);
        }// if
    
        else
        {    
            //pc.printf("0");
            wait(szero);
            
            for(k = 0; k < repeat0; k++)
            {
                irLed = 1;   
                wait(cycleOn);
                irLed = 0;   
                wait(cycleOff);
            }// for
            
        }// else
        
    }// for
    
    return;
}// strobeRC6


/* calculates and transmits either a leading 
 or trailing pulse, based on passed variables */

void Infrared::pulse(double pulseL)
{
    long float repeat;
    
    repeat = pulseL/(cycleOn+cycleOff);
    /* uses the length of the header pulse over the length of the on/off 
    modulation to give an integer representation of the number of cycles */
    
    repeat *= 0.78; // correction factor for loop overheads
    
    for(int k = 0; k < repeat; k++)
    {
        irLed = 1;   
        wait(cycleOn);
        irLed = 0;   
        wait(cycleOff);
    }// for
    
    return;
}// pulse


/* takes a command input and strobes the infrared LEDs */

void Infrared::sendCodeDish(unsigned long int command) 
{ 

    data = command;
    
    header(); 
    strobeSpace();
    
    header(); 
    strobeSpace();
    
    header(); 
    strobeSpace();
    
    pulse(ptrail);
    
    wait(gap); 

    return;
}//sendCodeDVR


void Infrared::sendCodeGETV(unsigned long int command) 
{ 

    data = command;
    
    header(); 
    strobeSpace();
    pulse(ptrail);
    
    wait(gap);
    
    header(); 
    strobeSpace();
    pulse(ptrail); 

    wait(gap);

    return;
}//sendCodeGETV

void Infrared::sendCodeSharpTV(unsigned long int command) 
{ 

    invertCode(inversionMask, command);

    data = code;
    
    strobeSpace();
    pulse(ptrail);
    
    wait(gap);
    
    data = invCode;
    
    strobeSpace();
    pulse(ptrail); 
    
    wait(gap);
    
    data = code;
    
    strobeSpace();
    pulse(ptrail);
    
    wait(gap);
    
    data = invCode;
    
    strobeSpace();
    pulse(ptrail); 
    
    wait(gap);

    return;
}//sendCodeSharpTV


/* Takes the values for the remote timing in the LIRC remote files
   (which are in us, Ex. phead =  450) and converts them down to the 
   proper floating point value  */

void Infrared::convertTiming()
{

    phead /= 1000000; // convert to u seconds
    shead /= 1000000;
    pone /= 1000000;
    sone /= 1000000;
    pzero /= 1000000;
    szero /= 1000000;
    ptoggle /= 1000000;
    stoggle /= 1000000;
    ptrail /= 1000000;
    plead /= 1000000;
    gap /= 1000000; 
    
    /*cycleOn = 100/dutycycle; 
    irPeriod = 1/frequency;  
    cycleOn = irPeriod/cycleOn;
    cycleOff = cycleOn;*/
    
    cycleOn = dutycycle/100;  // dutycycle is read in as a percentage value from 0 to 100
    cycleOff = 1-cycleOn;
    irPeriod = 1/frequency;  
    cycleOn = irPeriod*cycleOn;
    cycleOff = irPeriod*cycleOff;
    
    return;
}// convertTiming



/* deciphers which mask is needed for sending 
data out msb first with dynamic data lengths */

void Infrared::maskBit(void) 
{   
    MSB = (0x01<<(dataBits-1)); 
    /* uses the dataBits and uses it to shift a one
     to the position of the MSB of the datastream */ 
    
    return;
}// maskBit


void Infrared::invertCode(int mask, int invertData)
{

    code = invertData;
    invCode = invertData;
    
    for(char i = 0; i < mask; i++)
    {
         
        invCode ^= (0x01<<i);  
        
    }// for
    
    return;
}// invertCode

