#include "mbed.h"
#include "Infrared.h"

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut led1 (LED1);
DigitalOut led2 (LED2);

Infrared TV(p21);
Infrared DVR(p21);

int main() {

    // these declared values will eventually be read off the SD micro card
    TV.phead = 350; TV.shead = 6100; TV.pone = 350; TV.sone = 1739; // values are time in us
    TV.pzero = 350; TV.szero = 690; TV.ptoggle = 0; TV.stoggle = 0;
    TV.frequency = 38000; TV.ptrail = 350; TV.plead = 0; TV.foot = 0; 
    TV.gap = 46000; TV.postdata = 0; TV.toggleMask = 0; TV.data = 0; 
    TV.preData = 0; TV.command = 0; TV.dutycycle = 50; 
    TV.preDataBits = 0; TV.dataBits = 15; TV.postDataBits = 0;
    
    TV.inversionMask = 10;

    // commands
    TV.on = 0x41A2; TV.chup = 0x4222; TV.chdn = 0x4122; TV.volup = 0x40A2; TV.voldn = 0x42A2;
    TV.one = 0x4202; TV.two = 0x4102; TV.three = 0x4302; TV.four = 0x4082; TV.five = 0x4282; 
    TV.six = 0x4182; TV.seven = 0x4382; TV.eight = 0x4042; TV.nine = 0x4242; TV.zero = 0x4142;
    TV.mute = 0x43A2; 
    
    DVR.phead = 400; DVR.shead = 6100; DVR.pone = 400; DVR.sone = 1700; // values are time in us
    DVR.pzero = 400; DVR.szero = 2800; DVR.ptoggle = 0; DVR.stoggle = 0;
    DVR.frequency = 56000; DVR.ptrail = 400; DVR.plead = 0; DVR.foot = 0; 
    DVR.gap = 6200; DVR.postdata = 0; DVR.toggleMask = 0; DVR.data = 0; 
    DVR.preData = 0; DVR.command = 0; DVR.dutycycle = 50; 
    DVR.preDataBits = 0; DVR.dataBits = 16; DVR.postDataBits = 0;
    
    // commands
    DVR.on = 0x0800; DVR.up = 0x6800; DVR.down = 0x7800; DVR.left = 0x7000; DVR.right = 0x6000;
    DVR.menu = 0x2C00; DVR.enter = 0x4000;

    char deviceSel = 0;
    
    TV.convertTiming();
    TV.maskBit();
    DVR.convertTiming();
    DVR.maskBit();   

    
    while(1){
    
    
    TV.sendCodeSharpTV(TV.on);
    
    led1 = !led1;
    wait(3);
    
    /*
        if(SEL){
            deviceSel = !deviceSel;
            led1 = !led1;
            led2 = !led2;
            while(SEL);
            wait(0.03);
        }// if
        
        if(ON){
            if(deviceSel){
            DVR.sendCodeDish(DVR.on);
            }// if
            else{
            TV.sendCodeSharpTV(TV.on);
            }// else
        }// if
        
        if(OneUP){
            if(deviceSel){
            DVR.sendCodeDish(DVR.menu);
            }// if
            else{
            TV.sendCodeSharpTV(TV.chup);
            }// else
        }// if
        
        if(OneDN){
            if(deviceSel){
            DVR.sendCodeDish(DVR.enter);
            }// if
            else{
            TV.sendCodeSharpTV(TV.chdn);
            }// else
        }
        
        if(TwoUP){
            if(deviceSel){
            DVR.sendCodeDish(DVR.up);
            }// if
            else{
            TV.sendCodeSharpTV(TV.volup);
            }// else
        }// if
        
        if(TwoDN){
            if(deviceSel){
            DVR.sendCodeDish(DVR.down);
            }// if
            else{
            TV.sendCodeSharpTV(TV.voldn);
            }// else
        }// if
        */
    }// while
}// main