#ifndef MBED_IR_H
#define MBED_IR_H

#include "mbed.h"
#include "SDFileSystem.h"

class Infrared {
public:

    // these declared values will eventually be read off the SD micro card
    
    // format
    int name, flags, eps, aeps;
    
    // Timing
    double phead, shead, pone, sone; // values are time in us
    double pzero, szero, ptoggle, stoggle, frequency;
    double ptrail, plead, foot, gap, pulseL;
    double irPeriod, cycleOn, cycleOff; 
    
    // data
    int postdata, toggleMask, data, code, invCode, preData, command, dutycycle, inversionMask;
    char preDataBits, dataBits, postDataBits, repeat;
    unsigned long int MSB;
    
    // commands
    int on, off, chup, chdn, volup, voldn;
    int one, two, three, four, five, six;
    int seven, eight, nine, zero;
    int up, down, left, right, mute;
    int enter, cancel, menu, info;
    
    // assigns specifier to output pin
    Infrared(PinName pin);

    void header(void);
    void strobeSpace(void);
    void strobeRC6(void);
    void pulse(void);
    void sendCodeDish(unsigned long int command);
    void sendCodeGETV(unsigned long int command);
    void sendCodeSharpTV(unsigned long int command);
    void convertTiming();
    void maskBit(void);
    void invertCode(int mask, int invertData);
  
private:  
    DigitalOut irLed;
};

#endif
