#include "wsDrive.h"

wsDrive::wsDrive(PinName mosi, PinName miso, PinName clk) : BurstSPI(mosi,miso,clk)
{
    frequency(2400000);
    format(12);
    pixArray = NULL;
    pixelLen = 0;
    pixArray16 = NULL;
}

void wsDrive::setData(pixelInfo *dataStart, uint16_t dataLen)
{
    pixArray = dataStart;
    pixelLen = dataLen;
    pixArray16 = NULL;
}

void wsDrive::setData(pixelInfo16 *dataStart, uint16_t dataLen)
{
    pixArray16 = dataStart;
    pixelLen = dataLen;
    pixArray = NULL;
}

void wsDrive::sendData()
{
    frequency(2400000);
    format(12);
    setFormat();

    uint16_t pixIndex = 0;
    if (pixArray)
    while (pixIndex < pixelLen) {
        sendPixel(pixArray + pixIndex++);
    }  
    else
    while (pixIndex < pixelLen) {
        sendPixel(pixArray16 + pixIndex++);
    }  
    
}

// each bytes sent as two 12 bit messages (3 bits of data per LED bit).
void wsDrive::sendByte(unsigned char value)
{
    
    uint16_t dataToSend = 0;
    
    uint8_t mask = 0x80;
    while (mask) {
        dataToSend += (value & mask)?0x06:0x4; // 100 for a 0 or  110 for a 1
        if (mask & 0x11) {                     // trans
          fastWrite(dataToSend); 
          dataToSend = 0;
        }
        dataToSend = dataToSend << 3;
        mask = mask >> 1;
    }
}

void wsDrive::sendPixel(pixelInfo *pixToSend)
{
    sendByte(pixToSend->G);
    sendByte(pixToSend->R);
    sendByte(pixToSend->B);
}

void wsDrive::sendPixel(pixelInfo16 *pixToSend)
{
    sendByte(pixToSend->G<255?(unsigned char)pixToSend->G:255);
    sendByte(pixToSend->R<255?(unsigned char)pixToSend->R:255);
    sendByte(pixToSend->B<255?(unsigned char)pixToSend->B:255);
}


