#include "mbed.h"
#include "USBMouseKeyboard.h"
#include "searchText.h"


/*
Magic key combos

r + logo  - open run box
m + logo  - minimise all
m + logo + shift - maximise all
right arrow + logo + shift - move current window right one monitor
l + logo - lock screen
*/

#define KEY_ENTER 0x0a

// turn off all LEDs (some boards they glow a bit if you don't).
// you may need to remove some depending on the board.
//BusOut LEDs(LED1, LED2, LED3, LED4, LED5, LED6, LED7);
int LEDs;
USBMouseKeyboard keyboard;


/// Run image searches at interval seconds for given number of repeats or -1 to run forever
void startSearches(float interval, int number);

void runCommand(char *address);

// enter a keyboard string
void sendString(const char *str);

// draw a mouse circle
void drawCircle(float radius, float time, bool dir=true);

// draw a mouse line
void drawLine(float length, float time, bool horizontal=true, bool direction=true);

// Turn caps lock on n seconds after they turn it off.
void forceCaps(float delay, float checkPeriod=0.5);

void maxVolume();
void capsOn();

main()
{
    LEDs = 0;
    wait(10);
    while (true) {
        capsOn();
        while ((keyboard.lockStatus() & 0x02) == 0x02) {
            wait(1);
        }
        maxVolume();
        runCommand("https://www.youtube.com/watch?v=dQw4w9WgXcQ");
        drawCircle(80,15);
        drawCircle(100,15);
        drawCircle(120,15);
        wait(60*5);
    }
}

int searchCount;
int searchStop;
Ticker searchTicker;

void doNextSearch()
{
    static int searchIndex = 0;
    keyboard.keyCode('r',KEY_LOGO);  // windows key an R
    wait(0.1); // delay to give the run box a chance to come up.
    sendString(searchPrefix);
    sendString( searches[searchIndex++] );
    sendString(searchSuffix);
    wait(0.05); // delay to give the run box a chance to come up.
    keyboard.putc(0x0a); // hit enter
    if (searchIndex == searchStringCount)
        searchIndex = 0;

    searchCount++;
    if (searchCount == searchStop)
        searchTicker.attach(NULL,0);
}

void startSearches(float interval, int number)
{
    searchCount = 0;
    searchStop = number;
    searchTicker.attach(doNextSearch,interval);
}

void runCommand(char *address)
{
    keyboard.keyCode('r',KEY_LOGO);  // windows key an R
    wait(0.1); // delay to give the run box a chance to come up.
    sendString(address);
    wait(0.05);
    keyboard.putc(0x0a); // hit enter
}

void sendString(const char *str)
{
    while (*str != 0) {
        keyboard.putc(*str);
        str++;
    }
}

void maxVolume()
{
    for (int i = 0; i<50; i++) {
        keyboard.mediaControl(KEY_VOLUME_UP);
    }
}

void drawCircle(float radius, float time, bool dir)
{

    const float timeStep = 0.05;
    float currentx = 0;
    float currenty = radius;
    int steps = time/timeStep;
    float angleDelta = 2*3.14159265359 / steps;
    float xPos,yPos;

    if (!dir)
        angleDelta = -angleDelta;


    for (int i = 0; i<steps; i++) {
        xPos = radius*sin(angleDelta*i);
        yPos = radius*cos(angleDelta*i);
        int xDelta = ((xPos - currentx) > 0)?(xPos - currentx) + 0.5 : (xPos - currentx) - 0.5 ;
        int yDelta = ((yPos - currenty) > 0)?(yPos - currenty) + 0.5 : (yPos - currenty) - 0.5 ;
        keyboard.move(xDelta,yDelta);
        currentx += xDelta;
        currenty += yDelta;
        wait(timeStep);
    }
}

void drawLine(float length, float time, bool horizontal, bool direction)
{

    const float timeStep = 0.05;
    float currentPos = 0;
    int steps = time/timeStep;
    float stepSize = length / steps;
    float movement;

    if (!direction)
        stepSize = -stepSize;

    for (int i = 0; i<steps; i++) {

        movement = stepSize*i - currentPos;
        int moveDelta;
        if (movement>0)
            moveDelta = movement+0.5;
        else
            moveDelta = movement-0.5;

        if (horizontal)
            keyboard.move(moveDelta,0);
        else
            keyboard.move(0,moveDelta);

        currentPos +=  moveDelta;
        wait(timeStep);
    }
}

Ticker capLockTick;
Timeout capLockTimer;
bool capsTimerActive = false;
float capsWaitPeriod = 60;

void capsOn(void)
{
    capsTimerActive = false;
    if ((keyboard.lockStatus() & 0x02) == 0)
        keyboard.keyCode(KEY_CAPS_LOCK);
}

void checkCapsLock(void)
{
    LEDs = keyboard.lockStatus();
    if ((keyboard.lockStatus() & 0x02) == 0) {
        if (!capsTimerActive) {
            capLockTimer.attach(capsOn,capsWaitPeriod);
            capsTimerActive = true;
        }
    } else {
        if (capsTimerActive) {
            capLockTimer.detach();
            capsTimerActive = false;
        }
    }
}

void forceCaps(float delay, float checkPeriod)
{
    if (checkPeriod == 0)
        capLockTick.attach(NULL,0);
    else {
        capsWaitPeriod = delay;
        capLockTick.attach(checkCapsLock,checkPeriod);
    }
}
