#ifndef __mBuinoSleep__
#define __mBuinoSleep__

#include "mbed.h"

extern BusOut LEDs;

extern DigitalIn progMode;

/// set true to do a clean PLL shutdown. Wakeup IRQ will run slow.
extern bool sleep_CleanShutdown;

/// List of supported sleep modes. WD suffix indicates the watchdog remains powered.
/// Take care when using deep power down.
enum sleepMode_t {Sleep, DeepSleep, DeepSleepWD, PowerDown, PowerDownWD, DeepPowerDown};

/// Enters the selected sleep mode
void mBuinoSleep(enum sleepMode_t mode);

#endif
