#include "mBuinoSleep.h"


BusOut LEDs(LED1, LED2, LED3, LED4, LED5, LED6, LED7);

DigitalIn progMode(P0_3,PullNone);

bool sleep_CleanShutdown = false;

void mBuinoSleep(enum sleepMode_t mode)
{

    uint8_t oldLEDState = LEDs;
    LEDs = 0;

    progMode.mode(PullNone);

    if ((mode == DeepPowerDown) && (LPC_PMU->PCON & 0x08)) // bit 3 high blocks deep power down.
        mode = PowerDown;

    switch (mode) {
        default:
        case Sleep:
            LPC_PMU->PCON = 0x0;
            SCB->SCR &= ~SCB_SCR_SLEEPDEEP_Msk;
            __WFI();
            break;

        case DeepSleep:
        case PowerDown:
        case PowerDownWD:
        case DeepSleepWD:
         {
            if ((mode == PowerDown) || (mode == PowerDownWD))
                LPC_PMU->PCON = 0x2;
            else
                LPC_PMU->PCON = 0x1;

            LPC_SYSCON->PDSLEEPCFG |= 0x7f;  // shut off everything we can.

            if ((mode == DeepSleepWD) || (mode == PowerDownWD))
              LPC_SYSCON->PDSLEEPCFG &= ~(1<<6);
              
            SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;

            bool IRCPowered = (LPC_SYSCON->PDRUNCFG & 0x01); // only used for cleen shutdown but defined here for scope reasons.
            if (!IRCPowered)
                LPC_SYSCON->PDRUNCFG &= 0xfffffffe; // power up the IRC

            if(sleep_CleanShutdown) {
                LPC_SYSCON->MAINCLKSEL    = 0x00; // switch to IRC to avoid glitches
                LPC_SYSCON->MAINCLKUEN    = 0x01;               /* Update MCLK Clock Source */
                LPC_SYSCON->MAINCLKUEN    = 0x00;               /* Toggle Update Register   */
                LPC_SYSCON->MAINCLKUEN    = 0x01;
                while (!(LPC_SYSCON->MAINCLKUEN & 0x01));       /* Wait Until Updated       */
            }

            LPC_SYSCON->PDAWAKECFG = LPC_SYSCON->PDRUNCFG; // switch on everything that is currently on when we wake up.
            __WFI();

            if(sleep_CleanShutdown) {
                LPC_SYSCON->MAINCLKSEL    = 0x03; // switch to PLL output
                LPC_SYSCON->MAINCLKUEN    = 0x01;               /* Update MCLK Clock Source */
                LPC_SYSCON->MAINCLKUEN    = 0x00;               /* Toggle Update Register   */
                LPC_SYSCON->MAINCLKUEN    = 0x01;
                while (!(LPC_SYSCON->MAINCLKUEN & 0x01));       /* Wait Until Updated       */
            }

            if (!IRCPowered)
                LPC_SYSCON->PDRUNCFG |= 0x01; // power down the IRC if it was off before
        }
        break;
        case DeepPowerDown:
            LPC_PMU->PCON = 0x3;
            LPC_SYSCON->PDSLEEPCFG |= 0x7f;  // shut off everything we can.
            SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
            __WFI();
    }
    LEDs = oldLEDState;
}
