#include "mbed.h"

// LED on/off times.
// First time is time between toggling sound IO pin and starting lights
// Allows for audio playback start latency and lead in time.
const float thunder1Times[] = {0.1,0.3,0.1,0.3,0.1,0.2,0.2,0.3,0.1,0.3};
const int thunder1Len       =   1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1  ;

const float thunder2Times[] = {0.1,0.3,0.1,0.3,0.1,0.2, 0.6 ,0.3,0.1,0.3,0.2,0.1, 2 ,0.3,0.15,0.4,0.1,0.2};
const int thunder2Len       =   1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1  + 1 + 1 + 1  ;

// min time between starting a thunder playback and starting the next audio
const float thunder1AudioLen = 20;
const float thunder2AudioLen = 25;

// min time between starting a SFX playback and starting the next audio
const float effectAudioLen = 5;


// actual time between sound starts will be these numbers plus the thunder/effect length above.
const float minTimeBetweenSounds = 10;
const float maxTimeBetweenSounds = 20;

// percentage chance of lightnings
const int pLightning = 40;
const int pLightning2 = 15;


const int randomRange = 10*(maxTimeBetweenSounds - minTimeBetweenSounds); // range of time between sounds in units of 10ths of a second 


DigitalOut soundEffectPin(P0_19);
DigitalOut thunder1Pin(P0_4);
DigitalOut thunder2Pin(P0_5);

DigitalOut LEDsPin(P0_18);

DigitalOut LED_1(LED1);
DigitalOut LED_2(LED2);
DigitalOut LED_3(LED3);
BusOut LED_47(LED4,LED5,LED6,LED7);




void LEDon()
{
    LEDsPin = 1;
    LED_1 = 1;
}

void LEDoff()
{
    LEDsPin = 0;
    LED_1 = 0;
}

void toggleLED()
{
    LEDsPin = !LEDsPin;
    LED_1 = LEDsPin;
}

void randomSoundEffect(void)
{
    LED_2 = 1;
    soundEffectPin = 0;
    wait(1);
    LED_2 = 0;
    soundEffectPin = 1;
    wait(effectAudioLen);
}

void thunderEffect1(void)
{
    LEDoff();
    thunder1Pin = 0;
    int count = 0;
    float totalTime = 0;
    while (count < thunder1Len) {
        wait (thunder1Times[count]);
        totalTime += thunder1Times[count];
        toggleLED();
        count++;
    }
    LEDoff();
    thunder1Pin = 1;
    if (thunder1AudioLen > totalTime)
        wait (thunder1AudioLen - totalTime);
}

void thunderEffect2(void)
{
    LEDoff();
    thunder2Pin = 0;
    int count = 0;
    float totalTime = 0;
    while (count < thunder2Len) {
        wait (thunder2Times[count]);
        totalTime += thunder2Times[count];
        toggleLED();
        count++;
    }
    LEDoff();
    thunder2Pin = 1;
    if (thunder2AudioLen > totalTime)
        wait (thunder2AudioLen - totalTime);
}


void playEffect(void)
{
    int randomOrder = rand() % 100;
    LED_47 = randomOrder;
    LED_3 = 1;
    if (randomOrder < pLightning) {
        LED_47 = 1;
        thunderEffect1();
    } else if (randomOrder < (pLightning+pLightning2)) {
        LED_47 = 2;
        thunderEffect2();
    } else {
        LED_47 = 3;
        randomSoundEffect();
    }
    LED_3 = 0;
}

void setupRandom(void)
{
    AnalogIn RandomIn(P0_14);
    // create a 32 bit number out of 32 LSBs from the ADC
    uint32_t seedValue = 0;
    uint16_t value;
    uint8_t counter;

    for (counter = 0; counter < 32; counter++) {
        seedValue = seedValue<<1;
        value = RandomIn.read_u16(); // reads a 10 bit ADC normalised to 16 bits.
        if (value & 0x0040)          // LSB of ADC output = 1
            seedValue++;
    }

    srand(seedValue);
}

main()
{
    LED_47 = 0;
    LED_2 = 0;
    LED_3 = 0;
    LEDoff();
    thunder1Pin = 1;
    thunder2Pin = 1;
    soundEffectPin = 1;

    setupRandom();

    float randomTime;
    while (true) {
        randomTime = minTimeBetweenSounds + (rand() % randomRange)/10.0;
        wait(randomTime);
        playEffect();
    }
}