#ifndef __SlowPWM_H__
#define __SlowPWM_H__
 
#include "mbed.h"


/// A basic class to create very slow PWM signals using Digital IO and timers.
/// If setting a period and high time then you must manually call start.
/// If setting a duty cycle then it will start automatically, make sure you've set the peiod first if you care about it.
class SlowPWM : public DigitalOut
{
public:
 
// constructor without setting anything going.
    SlowPWM( const PinName pin);
 
// constructor that also starts things running
    SlowPWM( const PinName pin, const float period, const float highTime);
 
/// set the period
    void setPeriod(const float period);
 
/// set the on time per cycle. If 0 or the period or longer timers are stopped and output set perminently 
    void setHighTime(const float highTime);

// set the on time per cycle as a fraction of the period.
    void setDutyCycle(const float cycle);
 
// stop things. 
    void stop();
 
// start things
    void start();
 
private:
// internal functions and variables not visible to the outside world
 
    void onTurnOff(void);
    void onCycleStart(void);
 
    Ticker cycleTimer;
    Timeout offTimer;
 
    float _timeOn;
    float _repeatTime;
};
#endif
