// example code on how to wake from sleep mode after a fixed period of time.

// Normal sleep we can use a timer but there isn't a huge power saving.

// DeepSleep or PowerDown we need to use the watchdog (via the WakeUp library)

// pick which version to compile, 1 for sleep, 0 for power down
#define normalSleep 0

#if normalSleep

// code for normal sleep mode:
#include "mbed.h"
#include "mBuinoSleep.h"

Ticker OneSecClock;

void onClock()
{
    NULL; // empty function, just need a place holder here
}
   
int main ()
{
    LEDs = 1;

    OneSecClock.attach(onClock,1);

    while (1) {
        wait(0.1);
        mBuinoSleep(Sleep);
        if (LEDs == 127)
            LEDs = 1;
        else
            LEDs = LEDs + 1;
    }
}


#else

// code for power down mode
#include "mbed.h"
#include "mBuinoSleep.h"
#include "WakeUp.h"
        
int main ()
{
    WakeUp::calibrate();
    LEDs = 1;

    while (1) {
        wait(0.1);
        WakeUp::set_ms(900);
        mBuinoSleep(PowerDownWD);
        if (LEDs == 127)
            LEDs = 1;
        else
            LEDs = LEDs + 1;
    }
}

#endif