
#include "mbed.h"
#include "EthernetInterface.h"
#include "plotly.h"

Serial pc(USBTX,USBRX);

EthernetInterface eth;

// plotly account details
const int numberOfTraces = 3;
const char PlotlyUsername[] =  "YoutUsername";
const char PlotlyAPIToken[] = "YourAPIKey";
const char *PlotlyStreamingTokens[numberOfTraces] = {"YourStreamToken","YourSecondStreamToken"}; // or {"YourStreamToken"} for a single line. Must match numberOfTraces
const char PlotlyFileName[] = "Mbed Test Chart";

plotly graph = plotly(PlotlyUsername,PlotlyAPIToken, PlotlyStreamingTokens, PlotlyFileName, numberOfTraces);

void plotSetup()
{
    graph.log_level = 1; // turn on status output
    graph.maxpoints = 72;
    if (graph.init()) {
        graph.openStreams();
    }

}

// Generate some simple sample data points
void plotGenerateDataPoint()
{
    static float counter = 0;
    
    // generate a series of sine waves with slightly different frequencies.
    for (int i = 0; i < numberOfTraces; i++) {
      graph.plot(counter, (float)sin(counter * (1-i*0.1)), i); 
    }
    
    counter+=0.2;
}


int main()
{
    pc.baud(115200);

    pc.printf("Connecting network...\n");

    eth.init();
    eth.connect();

    char *ipAddress = eth.getIPAddress();
    if (ipAddress && (strlen(ipAddress) > 4)) {

        pc.printf("IP Address is %s\n",eth.getIPAddress());
        pc.printf("Initalise plot..\n");

        plotSetup();

        pc.printf("Generating data, press any key to abort.\n");
        while (!pc.readable()) {
            plotGenerateDataPoint();
            wait(0.5);
            }
        graph.closeStreams();

    } else
        pc.printf("No IP Address\n");

    eth.disconnect();

    pc.printf("Done\n");

    while (1) {
      wait(10);
    }
}