#include "mbed.h"
#include <string>

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

//***********************************************************************************
//***Set up the Serial communication to your PC**************************************
//***Type some Keys and when pressing enter, mbed will send some analyzed strings****
//***********************************************************************************

int main() 
{
    
    char ch[40];
    int count=0;
    char buf1[30];
    char buf2[30];
    
    while(1) 
    {
      
      if(pc.readable())
      {
        
        
        //store char in char array (ch)
        ch[count]= pc.getc();
        //print out to PC for better visibility/response
        pc.putc(ch[count]);
        
        //if receiving ENTER - print out everything and reset counter
         if(ch[count] == '\r')
         {
          pc.printf("\n\rCharacters received: %d \n\r",count);
          pc.printf("First three characters: %c%c%c \n\r",ch[0],ch[1],ch[2]);
          pc.printf("Second three characters: %c%c%c \n\r",ch[3],ch[4],ch[5]); 
          
          
               //devide ch array into two separate char arrays (buf1 and buf2)
               sprintf(buf1,"%c%c%c",ch[0],ch[1],ch[2]);
               sprintf(buf2,"%c%c%c",ch[3],ch[4],ch[5]);
          
               //***compare the two new char arrays***************************************************
               if(strcmp(buf1,buf2) == 0)
               {
               pc.printf("First and second three characters are identicaly: %s \n\n\r",buf1);  
               }
               else
               {
               pc.printf("First and second three characters are not identicaly \n\n\r");
               }
               //****************************************************************************************
          
          count=0;
          } 
         
         
         
         
         //else count up and store all received char's in the array
         else
         {
         count++; 
         }
        
      }
      
      
        
    }
}
