#include "mbed.h"
#include "PINNAMES.h"
#include "SPICOMMANDS.h"
#include "PROTOTYPES.h"
//#include "CAN_Data.h"
//#include "CAN_IDs.h"

int main() {
  
    //main loop variables
    bool Shutdown = false;
    OpModesym OpMode= Setup;            //OpMode variable
    Errorsym ErrorFlag = False;         //Error flag
    
    //angle limits
    const double Upperlimit_Can_on = 0;
    const double Upperlimit_Can_off = 0;
    const double Lowerlimit_Can_on = 100;
    const double Lowerlimit_Can_off = 100;
    
    //allocate memorry for data
    float LDR1;                       //LDR1's value
    float LDR2;                       //LDR2's value
    
    //spi send and decoded recieve buffers
    uint8_t write_buf [8];
    for (int i=0;i<8;i++){
        write_buf[i] = 0x00;
    }
                    
    uint8_t decoded_buf[7];
    
    
    
    float MPPT [5];
    #define bat_volt MPPT[0]
    #define bat_current MPPT[1]
    #define bat_temp MPPT[2]
    #define bat_status MPPT[3]
    #define PV_volt MPPT[4]
    
    uint8_t panel_locations [6];         //the array for actual/desired location of each panel
    
    //setup SPI
    printf("spi setup \r\n");
    const int spiBitrate=250000;
    spi.format(8,3);
    spi.frequency(spiBitrate);  
    SlaveSelect = 1;
    
    wait(2);
    
    //main loop.  
    while(1){
        if(ErrorFlag==False){
            switch (OpMode){
                case Setup:           
                    printf("Setup mode \r\n");
                    SlaveSelect = 0;
                    //start in correct mode
                    
                    //test region
                    write_buf[0] = 0xAA; //message start, AA is a reserved message don't send at any other time
                    write_buf[1] = 0xF0; //chip id
                    write_buf[2] = 0xA0; //message verb
                    write_buf[3] = 0x01; //message noun
                     
                    for (int i=5;i<8;i++){ //spare nouns or verbs
                        write_buf[i] = 0xFF;
                    }
                    printf("begin send \r\n");
                    spi_send(write_buf,decoded_buf);
                    printf("send exited \r\n");
                    StatusLED = 1;
                    wait_ms(1000);
                    StatusLED = 0;
                    wait_ms(1000);     
                    printf("restarting \r\n");
                    // end of test region
                    
                    
                    
                    //OpMode = readswitches();
                    break;        

                case Canopy_on:
                    printf("Canopy_on mode \r\n");
                    checkLDR(LDR1,LDR2);
                    checkMPPT(MPPT);
                    if(shouldmove(MPPT,LDR1,LDR2,Upperlimit_Can_on,Lowerlimit_Can_on,panel_locations)){
                        sendlocations(panel_locations);
                    }
                    else{   
                        wait(120);
                    }
                    OpMode = readswitches();
                    break;
                                    
                case Canopy_off:
                    printf("Canopy_off mode \r\n");
                    checkLDR(LDR1,LDR2);
                    checkMPPT(MPPT);
                    if(shouldmove(MPPT,LDR1,LDR2,Upperlimit_Can_off,Lowerlimit_Can_off,panel_locations)){
                        sendlocations(panel_locations);
                    }
                    else{
                        wait(120);
                    }
                    OpMode = readswitches();
                    break;
                
                case Manual:
                    printf("Manual mode \r\n");
                    //calibration mode - finds upper and lower limits for each panel for the current setup (canopy up or down)
                    
                    while(MANUAL_SW){//release the button
                    }
                    
                    //panels should be moved to lower limit
                    while(!MANUAL_SW){//then the switch should be pressed again
                    }            
                    
                    //TODO
                    //panel locations will be read and values stored as lower limit
                    
                    
                    while(MANUAL_SW){//release the button
                    }
                    
                    //then panels should be moved to the upper limit
                    while(!MANUAL_SW){//then the switch should be pressed again
                    }

                    //TODO
                    //panel locations will be read and values stored as upper limit
                    
                    
                    while(MANUAL_SW){//release the button
                    }                

                    break;
                
                
                case Error:
                    printf("Error mode \r\n");
                    ErrorFlag = Switch_Error;
                    break;
                    
                default:
                    printf("Default mode \r\n");
                    OpMode = Error;
                    break;
                }
            
        }
        else{   //do this if shutting down
            switch (ErrorFlag){
                case False:
                    OpMode= Setup;
                    break;
                
                case Switch_Error:
                    OpMode = Canopy_on;
                    break;
                    
                default:
                    Shutdown = true;                                 
                    break;
            }
        }
        if(Shutdown){
            break;
        }
    }
    
    printf("Out of loop \r\n");
    
}

OpModesym readswitches(){ //read canopy switches
    if(MANUAL_SW){
        return Manual;
    }
    else{
        if(CANOPY_SW){
            return  Canopy_on;  
        }
        else{
            return Canopy_off;
        }
    }
}
void checkLDR(float &LDR1,float &LDR2){ //get the LDR values
    LDR1 = LDR_SENSE1;
    LDR2 = LDR_SENSE1;
}

void checkMPPT(float *MPPT){ //get the MPPT values
    //TODO
}

bool shouldmove(float *MPPT,float LDR1,float LDR2,double Upperlimit,double Lowelimit,uint8_t *panel_locations){ //checks if the motors should move based on current location and sensor data
        //TODO
        //need to use "getlocations"
        return true;
}

void getlocations(double Upperlimit, double Lowerlimit,uint8_t *panel_locations){ //update panel locations from actual to desired
        //TODO
        //update panellocations
}

void sendlocations(uint8_t *panel_locations){ //transmit the desired locations
    //TODO send useful information get output to be   
}

uint8_t toEncoder(double angle){ //convert angle to encoder value
    //TODO
}

void spi_send(uint8_t write_buf [8],uint8_t decoded_buf[7]){
    uint8_t read_buf [8];
    
    SlaveSelect = 0;
    spi.write(0b00000000); //Ensures isoSPI is in ready
    SlaveSelect=1;
    
    wait_us(100);
    SlaveSelect = 0;
    wait_us(70);
    for (int i = 0; i < 8; i++) {
        spi.write(write_buf[i]);
        wait_us(60);
    }
    
    for (int i = 0; i < 8; i++) {
        read_buf[i] = spi.write(0xFF);
        wait_us(60);
    }
    SlaveSelect=1;    
    
    uint8_t MSB_byte = read_buf[7];
    
    for (int i = 0;i<7;i++){      
        if(!(MSB_byte & (0b00000001<<(i)))){
            decoded_buf[i] = read_buf[i]&0b01111111;
        }
        else{
            decoded_buf[i] = read_buf[i];
        }
        
        
        printf("decoded:  %u \r\n",decoded_buf[i]);
    }
    for (int i = 0;i<8;i++){  
        printf("read:  %u \r\n",read_buf[i]);
    }
    

    wait_us(30);
    printf("msg sent \r\n");
    return;
}